clear all;
close all;
clc;

TextSizes.DefaultAxesFontSize = 14;
TextSizes.DefaultTextFontSize = 18;
set(0,TextSizes);

%% PROCESS
% X_1 -> X_2, rate = k_1*[X_1]
% X_2 -> X_1, rate = k_2*[X_2]
% Y = X_2

%% DATA
sigma2 = 0.015^2;
t = [0:10]';
ym = [0.0244
      0.0842
      0.1208
      0.1724
      0.2315
      0.2634
      0.2831
      0.3084
      0.3079
      0.3097
      0.3324];

%% DEFINITION OF PARAMETER ESTIMATION PROBLEM
% Parameters
parameters.name = {'log_{10}(k_1)','log_{10}(k_2)'};
parameters.min = [-7,-7];
parameters.max = [ 3, 3];
parameters.number = 2;

% Log-likelihood function
options.obj_type = 'log-posterior';
logL = @(theta) logL__CR(theta,t,ym,sigma2,'log');

%% MULTI-START LOCAL OPTIMIZATION
% Options
options.n_starts = 10;
options.type = 'sequential'; options.mode = 'visual';
% options.type = 'parallel'; options.mode = 'silent'; % n_workers = 10;
% options.save = 'true'; options.foldername = 'results';

% % Open matlabpool
% if strcmp(options.type,'parallel')
%     matlabpool(n_workers);
% end

% Optimization
tic;
parameters = getMultiStarts(parameters,logL,options);
toc

%% VISUALIZATION: FIT
if strcmp(options.mode,'visual')
    % Simulation
    tsim = linspace(t(1),t(end),100);
    ysim = sim__CR(exp(parameters.MS.par(:,1)),tsim);

    % Plot: Fit
    figure;
    plot(t,ym,'bo'); hold on;
    plot(tsim,ysim,'r-'); 
    xlabel('time t');
    ylabel('output y');
    legend('data','fit');
end

%% Profile likelihood calculation
tic;
parameters = getProfiles(parameters,logL,options);
toc

%% Markov chain Monte-Carlo sampling
clc;
close all;

% options.sampling_scheme = 'DRAM';
options.sampling_scheme = 'single-chain';
% options.proposal_scheme = 'MALA'; options.w_hist = 0;
% options.proposal_scheme = 'MALA'; options.w_hist = 0.5;
options.proposal_scheme = 'MALA'; options.w_hist = 1;
% options.proposal_scheme = 'AM';


options.nsimu_warmup = 5e2;
options.nsimu_run    = 5e3;

parameters = getSamples(parameters,logL,options);

%% Confidence interval evaluation
alpha = [0.9,0.95,0.99];
parameters = getConfidenceIntervals(parameters,alpha);


% %
% if strcmp(options.type,'parallel')
%     matlabpool('close');
% end
