% plotMS_stats plots the statistics of the multi-start optimization stored in parameters.
%
% USAGE:
% ======
% fh = plotMS(parameters)
% fh = plotMS(parameters,fh)
% fh = plotMS(parameters,fh,options)
%
% INPUTS:
% =======
% parameters ... parameter struct containing information about parameters
%   and profile likelihood.
% fh ... handle of figure in which profile likelihood is plotted. If no
%   figure handle is provided, a new figure is opened.
%
% Outputs:
% ========
% fh .. figure handle
%
% 2014/07/31 Jan Hasenauer

% function fh = plotMS_stats(parameters,fh,options)
function fh = plotMS_stats(varargin)

%% CHECK AND ASSIGN INPUTS
% Assign parameters
if nargin >= 1
    parameters = varargin{1};
else
    error('plotPL requires a parameter object as input.');
end

% Open figure
if nargin >= 2
    if ~isempty(varargin{2})
        fh = figure(varargin{2});
    else
        fh = figure;
    end
else
    fh = figure;
end

% Options
options.title = 'off';
options.bounds = 'on';
if nargin == 3
    options = setdefault(varargin{3},options);
end

hist(parameters.MS.MAP_list.fittingtime)
vline(mean(parameters.MS.MAP_list.fittingtime));
xlabel('fitting time')
ylabel('frequency')

title(['fitting statis: #converged fits = ' num2str(parameters.MS.MAP.n_converged)])



drawnow;
