clear all

model = 'model_1';
% model = 'model_trimerization';

MM = round(10.^linspace(2,5,25));

date_now = 'paper';

switch(model)
    case 'model_1'
        MM = MM(1:25);
    case 'model_trimerization'
        MM = MM(1:25);
    case 'model_1_noMRNA'
        MM = MM(25);
    case 'model_1_noComplex'
        MM = MM(25);
    case 'model_1_noProtein'
        MM = MM(25);
end


for M = MM

    switch(model)
        case 'model_1'
            filename_t = ['SSADATA_logt_M_' num2str(M) ];
             load(['./project/results/' model '/' filename_t '/' date_now '/results_r=100.mat'])
        case 'model_trimerization'
            filename_t = ['SSADATA_logt_M_' num2str(M) ]; 
            load(['./project/results/' model '/' filename_t '/' date_now '/results_r=80.mat'])
        case 'model_1_noMRNA'
            filename_t = ['SSADATA_logt_M_' num2str(M) '_noMRNA'];
            load(['./project/results/model_1/' filename_t '/' date_now '/results_r=30.mat'])
        case 'model_1_noComplex'
            filename_t = ['SSADATA_logt_M_' num2str(M) '_noComplex'];
            load(['./project/results/model_1/' filename_t '/' date_now '/results_r=72.mat'])
        case 'model_1_noProtein'
            filename_t = ['SSADATA_logt_M_' num2str(M) '_noProtein'];
            load(['./project/results/model_1/' filename_t '/' date_now '/results_r=11.mat'])
    end
    
   
    
%     list_xiRRE_MAPpar = NaN(100,33,size(parameters_volume_RRE_PL(1).MS.par,1));
%     list_xiEMRE_MAPpar = NaN(100,33,size(parameters_volume_EMRE_PL(1).MS.par,1));
%     list_xiIOS_MAPpar = NaN(100,33,size(parameters_volume_IOS_PL(1).MS.par,1));
%     list_xiLNA_MAPpar = NaN(100,33,size(parameters_volume_LNA_PL(1).MS.par,1));
%     list_xiMA2_MAPpar = NaN(100,33,size(parameters_volume_MA2_PL(1).MS.par,1));
%     list_xiMA3_MAPpar = NaN(100,33,size(parameters_volume_MA3_PL(1).MS.par,1));
       
    list_xiRRE_MAPpar = NaN(100,33,size(parameters_volume_RRE(1).MS.par,1));
    list_xiEMRE_MAPpar = NaN(100,33,size(parameters_volume_EMRE(1).MS.par,1));
    list_xiIOS_MAPpar = NaN(100,33,size(parameters_volume_IOS(1).MS.par,1));
    list_xiLNA_MAPpar = NaN(100,33,size(parameters_volume_LNA(1).MS.par,1));
    list_xiMA2_MAPpar = NaN(100,33,size(parameters_volume_MA2(1).MS.par,1));
    list_xiMA3_MAPpar = NaN(100,33,size(parameters_volume_MA3(1).MS.par,1));
    list_xiRRE_MAPlogL = NaN(100,33);
    list_xiEMRE_MAPlogL = NaN(100,33);
    list_xiLNA_MAPlogL = NaN(100,33);
    list_xiIOS_MAPlogL = NaN(100,33);
    list_xiMA2_MAPlogL = NaN(100,33);
    list_xiMA3_MAPlogL = NaN(100,33);
    
    for r=1:100
        r
        try
        if(strcmp(model,'model_1_noMRNA')||strcmp(model,'model_1_noComplex')||strcmp(model,'model_1_noProtein'))
            load(['./project/results/model_1/' filename_t '/' date_now '/results_r=' num2str(r) '.mat'])
        else
            load(['./project/results/' model '/' filename_t '/' date_now '/results_r=' num2str(r) '.mat'])
        end
        for o = 1:33
            if(strcmp(model,'model_1_noMRNA')||strcmp(model,'model_1_noComplex')||strcmp(model,'model_1_noProtein'))
                parameters_all(r,o).RRE=parameters_volume_RRE_PL(o);
                parameters_all(r,o).EMRE=parameters_volume_EMRE_PL(o);
                parameters_all(r,o).MA2=parameters_volume_MA2_PL(o);
                parameters_all(r,o).LNA=parameters_volume_LNA_PL(o);
                parameters_all(r,o).IOS=parameters_volume_IOS_PL(o);
                parameters_all(r,o).MA3=parameters_volume_MA3_PL(o);
            else
                parameters_all(r,o).RRE=parameters_volume_RRE(o);
                parameters_all(r,o).EMRE=parameters_volume_EMRE(o);
                parameters_all(r,o).MA2=parameters_volume_MA2(o);
                parameters_all(r,o).LNA=parameters_volume_LNA(o);
                parameters_all(r,o).IOS=parameters_volume_IOS(o);
                parameters_all(r,o).MA3=parameters_volume_MA3(o);
            end

            list_xiRRE_MAPpar(r,o,:) = parameters_all(r,o).RRE.MS.par(:,1);
            list_xiEMRE_MAPpar(r,o,:) = parameters_all(r,o).EMRE.MS.par(:,1);
            list_xiMA2_MAPpar(r,o,:) = parameters_all(r,o).MA2.MS.par(:,1);
            list_xiLNA_MAPpar(r,o,:) = parameters_all(r,o).LNA.MS.par(:,1);
            list_xiIOS_MAPpar(r,o,:) = parameters_all(r,o).IOS.MS.par(:,1);
            list_xiMA3_MAPpar(r,o,:) = parameters_all(r,o).MA3.MS.par(:,1);

            list_xiRRE_MAPlogL(r,o) = parameters_all(r,o).RRE.MS.logPost(1);
            list_xiEMRE_MAPlogL(r,o) = parameters_all(r,o).EMRE.MS.logPost(1);
            list_xiMA2_MAPlogL(r,o) = parameters_all(r,o).MA2.MS.logPost(1);
            list_xiLNA_MAPlogL(r,o) = parameters_all(r,o).LNA.MS.logPost(1);
            list_xiIOS_MAPlogL(r,o) = parameters_all(r,o).IOS.MS.logPost(1);
            list_xiMA3_MAPlogL(r,o) = parameters_all(r,o).MA3.MS.logPost(1);
            D_all{o,r} = D_volume(o);
        end
        catch
        end
    end

    if(strcmp(model,'model_1_noMRNA')||strcmp(model,'model_1_noComplex')||strcmp(model,'model_1_noProtein'))
        save(['./project/results/model_1/' filename_t '/' date_now '/results.mat'],...
             'parameters_all',...
             'list_xiRRE_MAPpar',...
             'list_xiEMRE_MAPpar',...
             'list_xiMA2_MAPpar',...%'list_xiLNA_MAPpar',...%'list_xiIOS_MAPpar',...%'list_xiMA3_MAPpar',...
             'list_xiRRE_MAPlogL',...
             'list_xiEMRE_MAPlogL',...
             'list_xiMA2_MAPlogL',...%'list_xiLNA_MAPlogL',...%'list_xiIOS_MAPlogL',...%'list_xiMA3_MAPlogL',...
             'D_all','M',...
             'theta_true','Omega',...
             'options_MS','parameters','filename','-v7.3');
        else
            save(['./project/results/' model '/' filename_t '/' date_now '/results.mat'],...
             'parameters_all',...
             'list_xiRRE_MAPpar',...
             'list_xiEMRE_MAPpar',...
             'list_xiMA2_MAPpar',...
             'list_xiLNA_MAPpar',...
             'list_xiIOS_MAPpar',...
             'list_xiMA3_MAPpar',...
             'list_xiRRE_MAPlogL',...
             'list_xiEMRE_MAPlogL',...
             'list_xiMA2_MAPlogL',...
             'list_xiLNA_MAPlogL',...
             'list_xiIOS_MAPlogL',...
             'list_xiMA3_MAPlogL',...
             'D_all','M',...
             'theta_true','Omega',...
             'options_MS','parameters','filename','-v7.3');   
        end
end
