load('/Users/F.Froehlich/Documents/MATLAB/SSE/project/results/JakStat/results_all.mat')

logPost_RRE_SD = parameters_RRE_all.MS.logPost;
t_RRE_SD = parameters_RRE_all.MS.t_cpu;
logPost_EMRE_SD = parameters_EMRE_all.MS.logPost;
t_EMRE_SD = parameters_EMRE_all.MS.t_cpu;
logPost_2MA_SD = parameters_MA2_all.MS.logPost;
t_2MA_SD = parameters_MA2_all.MS.t_cpu;

load('/Users/F.Froehlich/Documents/MATLAB/SSE/project/results/JakStat_FD/results_all_FD.mat')

logPost_RRE_FD = parameters_RRE_all.MS.logPost;
t_RRE_FD = parameters_RRE_all.MS.t_cpu;
logPost_EMRE_FD = parameters_EMRE_all.MS.logPost;
t_EMRE_FD = parameters_EMRE_all.MS.t_cpu;
logPost_2MA_FD = parameters_MA2_all.MS.logPost;
t_2MA_FD = parameters_MA2_all.MS.t_cpu;


cEMRE =[176/255,204/255,133/255];
cRRE = [105/255,143/255,204/255];
c2MA = [204/255,117/255,153/255];
cIOS = [134/255,153/255,101/255];
cLNA = [82/255,111/255,153/255];
c3MA = [153/255,89/255,118/255];

figure
subplot(1,3,1)
% hold on
% plot(-sign(logPost_RRE_FD).*log10(abs(logPost_RRE_FD)),'o-','color',cRRE)
% plot(-sign(logPost_EMRE_FD).*log10(abs(logPost_EMRE_FD)),'o-','color',cEMRE)
% plot(-sign(logPost_2MA_FD).*log10(abs(logPost_2MA_FD)),'o-','color',c2MA)
% 
% hold on
% plot(-sign(logPost_RRE_SD).*log10(abs(logPost_RRE_SD)),'*-','color',cRRE)
% plot(-sign(logPost_EMRE_SD).*log10(abs(logPost_EMRE_SD)),'*-','color',cEMRE)
% plot(-sign(logPost_2MA_SD).*log10(abs(logPost_2MA_SD)),'*-','color',c2MA)
hold on
plot(-abs(logPost_RRE_FD),'o-','color',cRRE)
plot(-abs(logPost_EMRE_FD),'o-','color',cEMRE)
plot(-abs(logPost_2MA_FD),'o-','color',c2MA)

hold on
plot(-abs(logPost_RRE_SD),'*-','color',cRRE)
plot(-abs(logPost_EMRE_SD),'*-','color',cEMRE)
plot(-abs(logPost_2MA_SD),'*-','color',c2MA)


% legend('RRE FD','EMRE FD','2MA FD','RRE S','EMRE S','2MA S')

box on
xlabel('starts')
ylabel('$$-J(\hat{\theta)})$$','Interpreter','Latex')
set(gca,'LineWidth',2)
set(gca,'FontSize',20)
xlim([1,101])
ylim([-80,-60])

% legend('LNA FD','IOS FD','3MA FD','LNA S','IOS S','3MA S')

subplot(1,3,2)
hold on
%h = {log10([t_RRE_FD,t_RRE_SD]),log10([t_EMRE_FD,t_EMRE_SD]),log10([t_2MA_FD,t_2MA_SD])};
%aboxplot(h,'labels',{'FD','Sens'},'colormap',[cRRE;cEMRE;c2MA])
methods = {'RRE','EMRE','2MA'};

for j = 1:length(methods)
    eval(['lb_FD = quantile(log10(t_' methods{j} '_FD(~isnan(t_' methods{j} '_FD))),0.05);'])
    eval(['m_FD = median(log10(t_' methods{j} '_FD(~isnan(t_' methods{j} '_FD))));'])
    eval(['ub_FD = quantile(log10(t_' methods{j} '_FD(~isnan(t_' methods{j} '_FD))),0.95);'])
    eval(['lb_SD = quantile(log10(t_' methods{j} '_SD(~isnan(t_' methods{j} '_SD))),0.05);'])
    eval(['m_SD = median(log10(t_' methods{j} '_SD(~isnan(t_' methods{j} '_SD))));'])
    eval(['ub_SD = quantile(log10(t_' methods{j} '_SD(~isnan(t_' methods{j} '_SD))),0.95);'])
    eval(['plot([lb_SD,ub_SD],[m_FD,m_FD],''+-'',''color'',c' methods{j} ',''LineWidth'',2);'])
end
% legend('RRE','EMRE','2MA')
for j = 1:length(methods)
    eval(['lb_FD = quantile(log10(t_' methods{j} '_FD(~isnan(t_' methods{j} '_FD))),0.05);'])
    eval(['m_FD = median(log10(t_' methods{j} '_FD(~isnan(t_' methods{j} '_FD))));'])
    eval(['ub_FD = quantile(log10(t_' methods{j} '_FD(~isnan(t_' methods{j} '_FD))),0.95);'])
    eval(['lb_SD = quantile(log10(t_' methods{j} '_SD(~isnan(t_' methods{j} '_SD))),0.05);'])
    eval(['m_SD = median(log10(t_' methods{j} '_SD(~isnan(t_' methods{j} '_SD))));'])
    eval(['ub_SD = quantile(log10(t_' methods{j} '_SD(~isnan(t_' methods{j} '_SD))),0.95);'])
    eval(['plot([m_SD,m_SD],[lb_FD,ub_FD],''+-'',''color'',c' methods{j} ',''LineWidth'',2);'])
end
axis square
set(gca,'LineWidth',2)
set(gca,'FontSize',20)
box on

lim = [0.5,5.5];

xlim(lim)
ylim(lim)
plot(lim,lim,'k:','LineWidth',2)
ylabel('log_{10}(opt. time FD [s])')
xlabel('log_{10}(opt. time FSE [s])')


conv = [sum(~isnan(logPost_RRE_FD)),sum(~isnan(logPost_EMRE_FD)),sum(~isnan(logPost_2MA_FD));
    sum(~isnan(logPost_RRE_FD)),sum(~isnan(logPost_EMRE_FD)),sum(~isnan(logPost_2MA_FD))];


subplot(1,3,3)
bar(conv',.75,'grouped');
ylim([0,1000])
legend('SE','FD');
legend boxoff
set(gca,'LineWidth',2)
set(gca,'FontSize',20)
set(gca,'XTickLabel',{'RRE','EMRE','2MA'})
ylabel('successfull starts')




set(gcf, 'PaperUnits','centimeters','PaperSize',[56 39],'PaperPositionMode','auto','Position',[100 300 1200 300])
saveas(gcf,['./project/results/JakStat/comp_fs_sd']);
print('-dpng','-r300',['./project/results/JakStat/comp_fs_sd'])
print('-depsc','-r300',['./project/results/JakStat/comp_fs_sd'])

