clear
close all hidden

% model = 'model_1';
model = 'model_trimerization';
filename = 'SSADATA_logt_M_100000';
dataext = '';
date = '06-Jun-2014';
date = '08-Jul-2014';
date = '19-Aug-2014';
date = '20-Aug-2014';
date = '28-Aug-2014';
date = '01-Sep-2014';
date = '05-Sep-2014';
date = '03-Dec-2014';
date = '19-Jan-2015';
date = '18-Feb-2015';
%date = '19-Sep-2014';
%date = '24-Sep-2014';
date = '03-Mar-2015';

percentile = 0.8;

momentflag = true;

lperc = (1-percentile)/2;
uperc = 1-lperc;

R = 100;

load(['./project/results/' model '/' filename '/' date '/results.mat'])

IOS_par = list_xiIOS_MAPpar;
EMRE_par = list_xiEMRE_MAPpar;
LNA_par = list_xiLNA_MAPpar;
RRE_par = list_xiRRE_MAPpar;
if(momentflag)
    MA2_par = list_xiMA2_MAPpar;
    MA3_par = list_xiMA2_MAPpar;
end

IOS_llh = permute(reshape(list_xiIOS_MAPlogL(:),R,length(Omega)),[2,1]);
EMRE_llh = permute(reshape(list_xiEMRE_MAPlogL(:),R,length(Omega)),[2,1]);
LNA_llh = permute(reshape(list_xiLNA_MAPlogL(:),R,length(Omega)),[2,1]);
RRE_llh = permute(reshape(list_xiRRE_MAPlogL(:),R,length(Omega)),[2,1]);
if(momentflag)
    MA3_llh = permute(reshape(list_xiMA3_MAPlogL(:),R,length(Omega)),[2,1]);
    MA2_llh = permute(reshape(list_xiMA2_MAPlogL(:),R,length(Omega)),[2,1]);
end

if(~exist(['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models'],'dir'))
    mkdir(['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models'])
end

if(strcmp(model,'model_1'))
    map_param = [2,5,1,6,3,7,6,4];
else
    map_param = [1,2,3,5,6,7];
end

%% ESTIMATE


cEMRE =[176/255,204/255,133/255];
cRRE = [105/255,143/255,204/255];
c2MA = [204/255,117/255,153/255];
cIOS = [134/255,153/255,101/255];
cLNA = [82/255,111/255,153/255];
c3MA = [153/255,89/255,118/255];

for varflag = [0,1]
    if(varflag)
        O0_par = LNA_par;
        O1_par = IOS_par;
        if(momentflag)
        O2_par = MA3_par;
        %O2_par = MA2_par;
        end
        cstr0_s = '-';        
        cstr0_d = '-';
        c0 = cLNA;
        cstr1_s = '-';
        cstr1_d = '-';
        c1 = cIOS;
        cstr2_s = '-';
        cstr2_d = '-';
        c2 = c3MA;
    else
        O0_par = RRE_par;
        O1_par = EMRE_par;
        if(momentflag)
        O2_par = MA2_par;
        end
        cstr0_s = '-';
        cstr0_d = '-';
        c0 = cRRE;
        cstr1_s = '-';
        cstr1_d = '-';
        c1 = cEMRE;
        cstr2_s = '-';
        cstr2_d = '-';
        c2 = c2MA;
    end
    
    figure;
    
    if(strcmp(model,'model_1'))
        j=8;
        subtightplot(2,4,8)
    else
        j=7;
        subtightplot(2,4,8)
    end
    
    hold on
    plot(Omega,nanmedian(O1_par(:,:,j),1),cstr1_s,'LineWidth',5,'Color',c1)
    if(momentflag)
        plot(Omega,nanmedian(O2_par(:,:,j),1),cstr2_s,'LineWidth',5,'Color',c2)
    end
    if(varflag)
        plot(Omega,nanmedian(O0_par(:,:,j),1),cstr0_s,'LineWidth',5,'Color',c0)
        plot(Omega,quantile(O0_par(:,:,j),lperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        plot(Omega,quantile(O0_par(:,:,j),uperc,1),cstr0_d,'LineWidth',2,'Color',c0)
    end
    plot(Omega,quantile(O1_par(:,:,j),lperc,1),cstr1_d,'LineWidth',2,'Color',c1)
    plot(Omega,quantile(O1_par(:,:,j),uperc,1),cstr1_d,'LineWidth',2,'Color',c1)
    if(momentflag)
        plot(Omega,quantile(O2_par(:,:,j),lperc,1),cstr2_d,'LineWidth',2,'Color',c2)
        plot(Omega,quantile(O2_par(:,:,j),uperc,1),cstr2_d,'LineWidth',2,'Color',c2)
    end
    
    set(gca,'XScale','log')
    set(gca,'XTick',[1e0,1e1,1e2,1e3])
    set(gca,'YTick',[])
    xlabel('\Omega','FontSize',40)
    % ylabel(['MSE'],'FontSize',40)
    title( parameters.name{j} ,'FontSize',40)
    xlim([Omega(1),Omega(end)])
    set(gca, 'FontSize', 40)
    box on
    axis square
    hline(log10(theta_true(j)))
    
    if(strcmp(model,'model_1'))
        j=7;
        subtightplot(2,4,4)
        hold on
        plot(Omega,nanmedian(O1_par(:,:,j),1),cstr1_s,'LineWidth',5,'Color',c1)
        plot(Omega,nanmedian(O0_par(:,:,j),1),cstr0_s,'LineWidth',5,'Color',c0)
        if(momentflag)
            plot(Omega,nanmedian(O2_par(:,:,j),1),cstr2_s,'LineWidth',5,'Color',c2)
        end
        plot(Omega,quantile(O1_par(:,:,j),lperc,1),cstr1_d,'LineWidth',2,'Color',c1)
        plot(Omega,quantile(O1_par(:,:,j),uperc,1),cstr1_d,'LineWidth',2,'Color',c1)
        plot(Omega,quantile(O0_par(:,:,j),lperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        plot(Omega,quantile(O0_par(:,:,j),uperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        if(momentflag)
            plot(Omega,quantile(O2_par(:,:,j),lperc,1),cstr2_d,'LineWidth',2,'Color',c2)
            plot(Omega,quantile(O2_par(:,:,j),uperc,1),cstr2_d,'LineWidth',2,'Color',c2)
        end
        hline(log10(theta_true(j)));
        set(gca,'XScale','log')
        set(gca,'XTick',[])
        set(gca,'YTick',[])
        % xlabel('\Omega','FontSize',240)
        % ylabel(['MSE'],'FontSize',40)
        title( parameters.name{j} ,'FontSize',40)
        xlim([Omega(1),Omega(end)])
        set(gca, 'FontSize', 40)
        box on
        axis square
        hline(log10(theta_true(j)))
    end
    
    
    
    
    for j = 1:6
        i = map_param(j);
        subtightplot(2,4,i)
        
        %     subplot(2,4,i)
        hold on
        plot(Omega,nanmedian(O1_par(:,:,j),1),cstr1_s,'LineWidth',5,'Color',c1)
        plot(Omega,nanmedian( O0_par(:,:,j),1),cstr0_s,'LineWidth',5,'Color',c0)
        if(momentflag)
            plot(Omega,nanmedian(O2_par(:,:,j),1),cstr2_s,'LineWidth',5,'Color',c2)
        end
        hline(log10(theta_true(i)));
        plot(Omega,quantile(O1_par(:,:,j),lperc,1),cstr1_d,'LineWidth',2,'Color',c1)
        plot(Omega,quantile(O1_par(:,:,j),uperc,1),cstr1_d,'LineWidth',2,'Color',c1)
        plot(Omega,quantile(O0_par(:,:,j),lperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        plot(Omega,quantile(O0_par(:,:,j),uperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        if(momentflag)
            plot(Omega,quantile(O2_par(:,:,j),lperc,1),cstr2_d,'LineWidth',2,'Color',c2)
            plot(Omega,quantile(O2_par(:,:,j),uperc,1),cstr2_d,'LineWidth',2,'Color',c2)
        end
        
        set(gca,'XScale','log')
        if(any([i==1,i==5]))
            ylabel(['log_{10}(\theta)'],'FontSize',40)
        else
            set(gca,'YTick',[])
        end
        if(i>4)
            xlabel('\Omega','FontSize',40)
            set(gca,'XTick',[1e0,1e1,1e2,1e3])
        else
            set(gca,'XTick',[])
        end
        if(i==1)
            if(varflag)
                if(momentflag)
                    legend('IOS','LNA','3MA','True','Location','NorthEast')
                else
                    legend('IOS','LNA','True','Location','NorthEast')
                end
            else
                if(momentflag)
                    legend('EMRE','RRE','2MA','True','Location','NorthEast')
                else
                    legend('EMRE','RRE','True','Location','NorthEast')
                end
            end
        end
        
        
        
        title( parameters.name{j} ,'FontSize',40)
        xlim([Omega(1),Omega(end)])
        set(gca, 'FontSize', 40)
        box on
        axis square
        hline(log10(theta_true(j)))
    end
    
    if(varflag)
        set(gcf, 'PaperUnits','centimeters','PaperSize',[56 39],'PaperPosition',[2 0 58 39],'Position',[10 0 1010 640])
        saveas(gcf,['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_par_var_all']);
        print('-depsc','-tiff','-r300',['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_par_var_all'])
    else
        set(gcf, 'PaperUnits','centimeters','PaperSize',[56 39],'PaperPosition',[2 0 58 39],'Position',[10 0 1010 640])
        saveas(gcf,['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_par_mean_all']);
        print('-depsc','-tiff','-r300',['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_par_mean_all'])
    end
    
end

%% MSE

for varflag = [0,1]
    if(varflag)
        O0_par = LNA_par;
        O1_par = IOS_par;
        if(momentflag)
        O2_par = MA3_par;
        %O2_par = MA2_par;
        end
        cstr0_s = '-';        
        cstr0_d = '-';
        c0 = cLNA;
        cstr1_s = '-';
        cstr1_d = '-';
        c1 = cIOS;
        cstr2_s = '-';
        cstr2_d = '-';
        c2 = c3MA;
    else
        O0_par = RRE_par;
        O1_par = EMRE_par;
        if(momentflag)
        O2_par = MA2_par;
        end
        cstr0_s = '-';
        cstr0_d = '-';
        c0 = cRRE;
        cstr1_s = '-';
        cstr1_d = '-';
        c1 = cEMRE;
        cstr2_s = '-';
        cstr2_d = '-';
        c2 = c2MA;
    end
    
    figure;
    
    if(strcmp(model,'model_1'))
        j=8;
        subtightplot(2,4,8)
    else
        j=7;
        subtightplot(2,4,8)
    end
    
    hold on
    plot(Omega,nanmedian(log10((log10(repmat(Omega,R,1))-O1_par(:,:,j)).^2),1),cstr1_s,'LineWidth',5,'Color',c1)
    if(momentflag)
        plot(Omega,nanmedian(log10((log10(repmat(Omega,R,1))-O2_par(:,:,j)).^2),1),cstr2_s,'LineWidth',5,'Color',c2)
    end
    if(varflag)
        plot(Omega,nanmedian(log10((log10(repmat(Omega,R,1))-O0_par(:,:,j)).^2),1),cstr0_s,'LineWidth',5,'Color',c0)
        plot(Omega,quantile(log10((log10(repmat(Omega,R,1))-O0_par(:,:,j)).^2),lperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        plot(Omega,quantile(log10((log10(repmat(Omega,R,1))-O0_par(:,:,j)).^2),uperc,1),cstr0_d,'LineWidth',2,'Color',c0)
    end
    plot(Omega,quantile(log10((log10(repmat(Omega,R,1))-O1_par(:,:,j)).^2),lperc,1),cstr1_d,'LineWidth',2,'Color',c1)
    plot(Omega,quantile(log10((log10(repmat(Omega,R,1))-O1_par(:,:,j)).^2),uperc,1),cstr1_d,'LineWidth',2,'Color',c1)
    if(momentflag)
        plot(Omega,quantile(log10((log10(repmat(Omega,R,1))-O2_par(:,:,j)).^2),lperc,1),cstr2_d,'LineWidth',2,'Color',c2)
        plot(Omega,quantile(log10((log10(repmat(Omega,R,1))-O2_par(:,:,j)).^2),uperc,1),cstr2_d,'LineWidth',2,'Color',c2)
    end
    
    set(gca,'XScale','log')
    set(gca,'XTick',[1e0,1e1,1e2,1e3])
    set(gca,'YTick',[])
    xlabel('\Omega','FontSize',40)
    % ylabel(['MSE'],'FontSize',40)
    title( parameters.name{j} ,'FontSize',40)
    xlim([Omega(1),Omega(end)])
    ylim([-12,2])
    set(gca, 'FontSize', 40)
    box on
    axis square
    
    if(strcmp(model,'model_1'))
        j=7;
        subtightplot(2,4,4)
        hold on
        plot(Omega,nanmedian(log10((log10(theta_true(j))-O1_par(:,:,j)).^2),1),cstr1_s,'LineWidth',5,'Color',c1)
        if(momentflag)
            plot(Omega,nanmedian(log10((log10(theta_true(j))-O2_par(:,:,j)).^2),1),cstr2_s,'LineWidth',5,'Color',c2)
        end
        plot(Omega,nanmedian(log10((log10(theta_true(j))-O0_par(:,:,j)).^2),1),cstr0_s,'LineWidth',5,'Color',c0)
        plot(Omega,quantile(log10((log10(theta_true(j))-O1_par(:,:,j)).^2),lperc,1),cstr1_d,'LineWidth',2,'Color',c1)
        plot(Omega,quantile(log10((log10(theta_true(j))-O1_par(:,:,j)).^2),uperc,1),cstr1_d,'LineWidth',2,'Color',c1)
        if(momentflag)
            plot(Omega,quantile(log10((log10(theta_true(j))-O2_par(:,:,j)).^2),lperc,1),cstr2_d,'LineWidth',2,'Color',c2)
            plot(Omega,quantile(log10((log10(theta_true(j))-O2_par(:,:,j)).^2),uperc,1),cstr2_d,'LineWidth',2,'Color',c2)
        end
        plot(Omega,quantile(log10((log10(theta_true(j))-O0_par(:,:,j)).^2),lperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        plot(Omega,quantile(log10((log10(theta_true(j))-O0_par(:,:,j)).^2),uperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        set(gca,'XScale','log')
        set(gca,'XTick',[])
        set(gca,'YTick',[])
        % xlabel('\Omega','FontSize',240)
        % ylabel(['MSE'],'FontSize',40)
        title( parameters.name{j} ,'FontSize',40)
        xlim([Omega(1),Omega(end)])
        ylim([-12,2])
        set(gca, 'FontSize', 40)
        box on
        axis square
    end
    
    
    
    
    for j = 1:6
        i = map_param(j);
        subtightplot(2,4,i)
        
        %     subplot(2,4,i)
        hold on
        plot(Omega,nanmedian(log10((log10(theta_true(j))-O1_par(:,:,j)).^2),1),cstr1_s,'LineWidth',5,'Color',c1)
        if(momentflag)
            plot(Omega,nanmedian(log10((log10(theta_true(j))-O2_par(:,:,j)).^2),1),cstr2_s,'LineWidth',5,'Color',c2)
        end
        plot(Omega,nanmedian(log10((log10(theta_true(j))-O0_par(:,:,j)).^2),1),cstr0_s,'LineWidth',5,'Color',c0)
        plot(Omega,quantile(log10((log10(theta_true(j))-O1_par(:,:,j)).^2),lperc,1),cstr1_d,'LineWidth',2,'Color',c1)
        plot(Omega,quantile(log10((log10(theta_true(j))-O1_par(:,:,j)).^2),uperc,1),cstr1_d,'LineWidth',2,'Color',c1)
        if(momentflag)
            plot(Omega,quantile(log10((log10(theta_true(j))-O2_par(:,:,j)).^2),lperc,1),cstr2_d,'LineWidth',2,'Color',c2)
            plot(Omega,quantile(log10((log10(theta_true(j))-O2_par(:,:,j)).^2),uperc,1),cstr2_d,'LineWidth',2,'Color',c2)
        end
        plot(Omega,quantile(log10((log10(theta_true(j))-O0_par(:,:,j)).^2),lperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        plot(Omega,quantile(log10((log10(theta_true(j))-O0_par(:,:,j)).^2),uperc,1),cstr0_d,'LineWidth',2,'Color',c0)
        set(gca,'XScale','log')
        if(any([i==1,i==5]))
            ylabel(['log_{10}(MSE)'],'FontSize',40)
        else
            set(gca,'YTick',[])
        end
        if(i>4)
            xlabel('\Omega','FontSize',40)
            set(gca,'XTick',[1e0,1e1,1e2,1e3])
        else
            set(gca,'XTick',[])
        end
        if(i==1)
            if(varflag)
                if(momentflag)
                    legend('IOS','3MA','LNA','Location','NorthEast')
                else
                    legend('IOS','LNA','Location','NorthEast')
                end
            else
                if(momentflag)
                    legend('EMRE','2MA','RRE','Location','NorthEast')
                else
                   legend('EMRE','RRE','Location','NorthEast') 
                end
            end
        end
        
        
        
        title( parameters.name{j} ,'FontSize',40)
        xlim([Omega(1),Omega(end)])
        ylim([-12,2])
        set(gca, 'FontSize', 40)
        box on
        axis square
    end
    
    if(varflag)
        set(gcf, 'PaperUnits','centimeters','PaperSize',[56 39],'PaperPosition',[2 0 58 39],'Position',[10 0 1010 640])
        saveas(gcf,['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_MSE_var_all']);
        print('-depsc','-tiff','-r300',['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_MSE_var_all'])
    else
        set(gcf, 'PaperUnits','centimeters','PaperSize',[56 39],'PaperPosition',[2 0 58 39],'Position',[10 0 1010 640])
        saveas(gcf,['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_MSE_mean_all']);
        print('-depsc','-tiff','-r300',['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_MSE_mean_all'])
    end
    
end

%% CORR

for varflag = [0,1]
    if(varflag)
        O0_par = LNA_par;
        O1_par = IOS_par;
        if(momentflag)
        O2_par = MA3_par;
        %O2_par = MA2_par;
        end
        cstr0_s = '-';        
        cstr0_d = '-';
        c0 = cLNA;
        cstr1_s = '-';
        cstr1_d = '-';
        c1 = cIOS;
        cstr2_s = '-';
        cstr2_d = '-';
        c2 = c3MA;
    else
        O0_par = RRE_par;
        O1_par = EMRE_par;
        if(momentflag)
        O2_par = MA2_par;
        end
        cstr0_s = '-';
        cstr0_d = '-';
        c0 = cRRE;
        cstr1_s = '-';
        cstr1_d = '-';
        c1 = cEMRE;
        cstr2_s = '-';
        cstr2_d = '-';
        c2 = c2MA;
    end
    
    figure;
    
%     if(strcmp(model,'model_1'))
%         j=8;
%         subtightplot(2,4,8)
%     else
%         j=7;
%         subtightplot(2,4,8)
%     end
%     
%     hold on
%     if(varflag)
%     plot(Omega,arrayfun(@(x) corr(O1_par(:,x,j),O0_par(:,x,j)),1:17),cstr1_s,'LineWidth',5,'Color',c0)
%     end
%     if(momentflag)
%         plot(Omega,arrayfun(@(x) corr(O1_par(:,x,j),O2_par(:,x,j)),1:17),cstr1_s,'LineWidth',5,'Color',c1)
%         plot(Omega,arrayfun(@(x) corr(O0_par(:,x,j),O2_par(:,x,j)),1:17),cstr1_s,'LineWidth',5,'Color',c2)
%     end
%     
%     set(gca,'XScale','log')
%     set(gca,'XTick',[1e0,1e1,1e2,1e3])
%     set(gca,'YTick',[])
%     xlabel('\Omega','FontSize',40)
%     % ylabel(['MSE'],'FontSize',40)
%     title( parameters.name{j} ,'FontSize',40)
%     xlim([Omega(1),Omega(end)])
%     ylim([-12,2])
%     set(gca, 'FontSize', 40)
%     box on
%     axis square
    
    for j = 1:6
        i = map_param(j);
        subtightplot(2,4,i)
        
        %     subplot(2,4,i)
        hold on
        plot(Omega,arrayfun(@(x) corr(O1_par(:,x,j),O0_par(:,x,j),'rows','complete'),1:33),cstr1_s,'LineWidth',5,'Color',c0)
        if(momentflag)
            plot(Omega,arrayfun(@(x) corr(O1_par(:,x,j),O2_par(:,x,j),'rows','complete'),1:33),cstr1_s,'LineWidth',5,'Color',c1)
            plot(Omega,arrayfun(@(x) corr(O0_par(:,x,j),O2_par(:,x,j),'rows','complete'),1:33),cstr1_s,'LineWidth',5,'Color',c2)
        end

        set(gca,'XScale','log')
        if(any([i==1,i==5]))
            ylabel(['log_{10}(MSE)'],'FontSize',40)
        else
            set(gca,'YTick',[])
        end
        if(i>4)
            xlabel('\Omega','FontSize',40)
            set(gca,'XTick',[1e0,1e1,1e2,1e3])
        else
            set(gca,'XTick',[])
        end
        if(i==1)
            if(varflag)
                if(momentflag)
                    legend('LNA/IOS','IOS/3MA','3MA/LNA','Location','NorthEast')
                else
                    legend('IOS/LNA','Location','NorthEast')
                end
            else
                if(momentflag)
                    legend('RRE/EMRE','EMRE/2MA','2MA/RRE','Location','NorthEast')
                else
                   legend('EMRE/RRE','Location','NorthEast') 
                end
            end
        end
        
        
        
        title( parameters.name{j} ,'FontSize',40)
        xlim([Omega(1),Omega(end)])
        ylim([0,1])
        set(gca, 'FontSize', 40)
        box on
        axis square
    end
    
    if(varflag)
        set(gcf, 'PaperUnits','centimeters','PaperSize',[56 39],'PaperPosition',[2 0 58 39],'Position',[10 0 1010 640])
        saveas(gcf,['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_corr_var_all']);
        print('-depsc','-tiff','-r300',['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_corr_var_all'])
    else
        set(gcf, 'PaperUnits','centimeters','PaperSize',[56 39],'PaperPosition',[2 0 58 39],'Position',[10 0 1010 640])
        saveas(gcf,['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_corr_mean_all']);
        print('-depsc','-tiff','-r300',['./project/results/' options_MS.logPost_options.model '/' filename '/' date '/compare_models/compare_models_corr_mean_all'])
    end
    
end