function [] = generateArtificialData_SSA_enzyme(N,nvol)

%% Setup
Omega = [10.^linspace(0,4,nvol)]; % Volume range


%% Generation of artificial data
for i = 1:length(Omega)
        t = logspace(log10(1e-1),log10(30),301); % time points
%         t = linspace(0,30,100);
        disp(' ');
        disp(['Volume = ' num2str(Omega(i),'%d')]);
        % File name
        filename = ['./data/model_1/Data_' num2str(Omega(i),'%d') '_logt.mat'];
        % Simulation
        if Omega(i) < inf
            [~,X,m,C] = runSSA_gene_enzyme(Omega(i),t,N);
        else

        end
        % Save data
        parsave(filename,t,X,m,C);
        % Save and print figure
%         saveas(gcf,filename);
%         set(gcf, 'PaperUnits','centimeters','PaperPosition',[0 0 14 14])
%         print('-depsc',filename);
        % saveas(gcf,['./project/data/' filename]);
        % print('-depsc',['./project/data/' filename]);
        disp(' ');
end
end