function [] = generateArtificialData_SSA_trimerization(R,nvol)
%% Setup
Omega = [10.^linspace(0,4,nvol)]; % Volume range



%% Generation of artificial data
for i = 1:nvol
        t = logspace(log10(1e-1),log10(5),301); % time points
        disp(' ');
        disp(['Volume = ' num2str(Omega(i),'%d')]);
        % File name
        filename = ['./data/model_trimerization/Data_' num2str(Omega(i),'%d') '_logt'];
        % Simulation
        if Omega(i) < inf
            [~,X,m,C] = runSSA_trimerization(Omega(i),t,R);
        else

        end
        % Save data
        parsave(filename,t,X,m,C);
        % Save and print figure
%         saveas(gcf,filename);
%         set(gcf, 'PaperUnits','centimeters','PaperPosition',[0 0 14 14])
%         print('-depsc',filename);
        % saveas(gcf,['./project/data/' filename]);
        % print('-depsc',['./project/data/' filename]);
        disp(' ');
end
end