clear;
close all;
clc;

[exdir,~,~]=fileparts(which('estimationSSE.m'));
cd(exdir)

% add paths

addpath(genpath('./data'))
addpath(genpath('./models'))
addpath(genpath('./PESTO'))
addpath(genpath('./cvodewrap'))


%% generate artificial data

mex(fullfile(exdir,'data','model_trimerization','SSA_trimerization.cpp'))
mex(fullfile(exdir,'data','model_1','SSA_gene_enzyme.cpp'))

% number of SSA runs to sample from
N = 10000; % in the manuscript we used N=500000  but this takes an considerable amount of time
% number of volumes to consider between 10^0 and 10^4
nvol = 5; % in the manuscript we used vol=33  but this takes an considerable amount of time
generateArtificialData_SSA_enzyme(N,nvol)
generateArtificialData_SSA_trimerization(N,nvol)

%% compile models

cvodewrap('model_trimerization_RRE','model_trimerization_RRE_syms')
cvodewrap('model_trimerization_LNA','model_trimerization_LNA_syms')
cvodewrap('model_trimerization_EMRE','model_trimerization_EMRE_syms')
cvodewrap('model_trimerization_IOS','model_trimerization_IOS_syms')
cvodewrap('model_trimerization_2MA','MEC_2_LD_2_trimerization_syms')
cvodewrap('model_trimerization_3MA','MEC_3_LD_3_trimerization_syms')

cvodewrap('model_1_RRE','model_1_RRE_syms')
cvodewrap('model_1_LNA','model_1_LNA_syms')
cvodewrap('model_1_EMRE','model_1_EMRE_syms')
cvodewrap('model_1_IOS','model_1_IOS_syms')
cvodewrap('model_1_2MA','MEC_2_LD_2_enzyme_syms')
cvodewrap('model_1_3MA','MEC_3_LD_3_enzyme_syms')

addpath(genpath('./cvodewrap'))

% number of replicates
R = 5; % in the manuscript we used R=100  but this takes an considerable amount of time
% number of sample sizes between 10^2 and 10^5
nsample = 5; % in the manuscript we used N=5  but this takes an considerable amount of time

model = {'model_trimerization','model_1'};

%% Optimization

for j = 1:2
    for r = 1:R
        optimize_volume(model{j},num2str(r),nvol,nsample)
    end
end