%function [logL,grad] = logLikelihoodSSE(xi,D,model,options)
function varargout = logLikelihoodJakStat(varargin)
    
    %% CHECK/ASSIGN INPUTS:
    if nargin >= 3
        xi = varargin{1};
        kappa = varargin{2};
        D = varargin{3};
        model = varargin{4};
    else
        error('Not enough inputs!');
    end
    
    % Assign defaults for options
    options.sign = 'positive';
    options.grad_ind = [1:length(xi)]';
    if nargin == 5
        options = setdefault(varargin{5},options);
    end
    
    try
        
        if nargout>1
            options_simu.sensi = 1;
        else
            options_simu.sensi = 0;
        end
        
        options_simu.cvodes_atol = 1e-8;
        options_simu.cvodes_rtol = 1e-8;
        options_simu.cvodes_maxsteps = 1e4;
        %% Simulation
        switch model
            case 'RRE'
                sol = simulate_RRE_JakStat_red(D.t,xi(1:14),kappa,options_simu);
                my = sol.y;
            case 'EMRE'
                sol = simulate_EMRE_JakStat_red(D.t,xi(1:14),kappa,options_simu);
                my = sol.y(:,1:3);
            case '2MA'
                sol = simulate_MA2_JakStat_red(D.t,xi(1:14),kappa,options_simu);
                my = sol.y(:,1:3);
        end
        
        status = sol.status;
        
        if nargout>1
            switch model
                case 'RRE'
                    dmydxi = sol.sy;
                case 'EMRE'
                    dmydxi = sol.sy(:,1:3,:);
                case '2MA'
                    dmydxi = sol.sy(:,1:3,:);
            end
        end
        
        %% Log-likelihood function
        logL = 0;
        if nargout>1
            grad = zeros(length(xi),1);
            if nargout>2
                fish = zeros(length(xi),length(xi));
            end
        end
        
         sigma_pSTAT = 10^xi(15);
         sigma_tSTAT = 10^xi(16);
         sigma_pEpoR = 10^xi(17);
        
        % Mean
        nt = size(my,1);
        no = size(my,2);
        if nargout>1
            np = size(dmydxi,3);
        end
        D.sigma_my = repmat([sigma_pSTAT,sigma_tSTAT,sigma_pEpoR],[nt,1]);
        resmy = reshape((my-D.my)./(D.sigma_my),nt*no,1);
        nanidx = isnan(resmy);
        resmy(nanidx) = 0;
        if nargout>1
            sresmy = reshape(bsxfun(@times,dmydxi,1./(D.sigma_my)),nt*no,np);
            sresmy(nanidx,:) = 0;
        end
         logL = logL - 0.5*(nt-sum(nanidx(1:nt)))*log(2*pi*sigma_pSTAT^2) - 0.5*(nt-sum(nanidx((nt+1):2*nt)))*log(2*pi*sigma_tSTAT^2) - 0.5*(nt-sum(nanidx((2*nt+1):3*nt)))*log(2*pi*sigma_pEpoR^2) - 0.5*sum(resmy.^2);
%        logL = logL - 0.5*sum(resmy.^2);
        if nargout>1
            grad(1:14) = grad(1:14) - sresmy'*resmy;
            grad(15)   = grad(15) - (nt-sum(nanidx(1:nt)))*log(10) + sum(resmy(1:nt).^2)*log(10);
            grad(16)   = grad(16) - (nt-sum(nanidx((nt+1):2*nt)))*log(10) + sum(resmy((nt+1):2*nt).^2)*log(10);
            grad(17)   = grad(17) - (nt-sum(nanidx((2*nt+1):3*nt)))*log(10) + sum(resmy((2*nt+1):3*nt).^2)*log(10);
            if nargout>2
                fish(1:14,1:14) = fish(1:14,1:14) - sresmy'*sresmy;
                fish = fish + 1e-8*diag(14);
                fish(15,1:14) = + 2*sresmy(1:nt,:)'*resmy(1:nt)*log(10);
                fish(1:14,15) = + 2*sresmy(1:nt,:)'*resmy(1:nt)*log(10);
                fish(16,1:14) = + 2*sresmy((nt+1):2*nt,:)'*resmy((nt+1):2*nt)*log(10);
                fish(1:14,16) = + 2*sresmy((nt+1):2*nt,:)'*resmy((nt+1):2*nt)*log(10);
                fish(17,1:14) = + 2*sresmy((2*nt+1):3*nt,:)'*resmy((2*nt+1):3*nt)*log(10);
                fish(1:14,17) = + 2*sresmy((2*nt+1):3*nt,:)'*resmy((2*nt+1):3*nt)*log(10);
                fish(15,15) = - 2*sum(resmy(1:nt).^2)*log(10)*log(10);
                fish(16,16) = - 2*sum(resmy((nt+1):2*nt).^2)*log(10)*log(10);
                fish(17,17) = - 2*sum(resmy((2*nt+1):3*nt).^2)*log(10)*log(10);
            end
        end
        
        %Error catch
    catch
        logL = -inf;
        grad = zeros(length(xi),1);
        fish = zeros(length(xi),length(xi));
    end
    %
    if status < 0
        error('failed to integrate ODE')
    end
    
    %% ASSIGN OUTPUT
    switch nargout
        % One output
        case {0,1}
            switch  options.sign
                case 'positive'
                    varargout{1} =  logL;
                case 'negative'
                    varargout{1} = -logL;
            end
            % Two outputs
        case 2
            switch  options.sign
                case 'positive'
                    varargout{1} =  logL;
                    varargout{2} =  grad(options.grad_ind);
                case 'negative'
                    varargout{1} = -logL;
                    varargout{2} = -grad(options.grad_ind);
            end
        case 3
            switch  options.sign
                case 'positive'
                    varargout{1} =  logL;
                    varargout{2} =  grad(options.grad_ind);
                    varargout{3} =  fish(options.grad_ind,options.grad_ind);
                case 'negative'
                    varargout{1} = -logL;
                    varargout{2} = -grad(options.grad_ind);
                    varargout{3} = -fish(options.grad_ind,options.grad_ind);
            end
            
    end