%function [logL,grad] = logLikelihoodSSE(xi,D,model,options)
function varargout = logLikelihoodJakStat_FD(varargin)

if nargout == 1
    logL = logLikelihoodJakStat(varargin{1},varargin{2},varargin{3},varargin{4});
end

xi = varargin{1};

if nargout == 2
    logL = logLikelihoodJakStat(varargin{1},varargin{2},varargin{3},varargin{4});
    for j = 1:length(xi)
        xip = xi;
        vararginp = varargin;
        xip(j) = xip(j) + 1e-4;
        vararginp{1} = xip;
        logLp = logLikelihoodJakStat(vararginp{1},vararginp{2},vararginp{3},vararginp{4});
        grad(j) = (logLp-logL)/1e-4;
    end
end

if nargout >= 1
    varargout{1} = logL;
end
if nargout >= 2
    varargout{2} = grad;
end
end