function [model] = EMRE_JakStat_red_syms()

% CVODES OPTIONS

model.atol = 1e-12;
model.rtol = 1e-8;
model.maxsteps = 1e4;
model.param = 'log10';


% STATES

syms STAT pSTAT pSTAT_pSTAT nSTAT1 nSTAT2 nSTAT3 nSTAT4 nSTAT5 COV11_LNA COV21_LNA COV22_LNA COV31_LNA COV32_LNA COV33_LNA COV41_LNA COV42_LNA COV43_LNA COV44_LNA COV51_LNA COV52_LNA COV53_LNA COV54_LNA COV55_LNA COV61_LNA COV62_LNA COV63_LNA COV64_LNA COV65_LNA COV66_LNA COV71_LNA COV72_LNA COV73_LNA COV74_LNA COV75_LNA COV76_LNA COV77_LNA COV81_LNA COV82_LNA COV83_LNA COV84_LNA COV85_LNA COV86_LNA COV87_LNA COV88_LNA STAT_CORR_EMRE pSTAT_CORR_EMRE pSTAT_pSTAT_CORR_EMRE nSTAT1_CORR_EMRE nSTAT2_CORR_EMRE nSTAT3_CORR_EMRE nSTAT4_CORR_EMRE nSTAT5_CORR_EMRE

x = [
STAT, pSTAT, pSTAT_pSTAT, nSTAT1, nSTAT2, nSTAT3, nSTAT4, nSTAT5, COV11_LNA, COV21_LNA, COV22_LNA, COV31_LNA, COV32_LNA, COV33_LNA, COV41_LNA, COV42_LNA, COV43_LNA, COV44_LNA, COV51_LNA, COV52_LNA, COV53_LNA, COV54_LNA, COV55_LNA, COV61_LNA, COV62_LNA, COV63_LNA, COV64_LNA, COV65_LNA, COV66_LNA, COV71_LNA, COV72_LNA, COV73_LNA, COV74_LNA, COV75_LNA, COV76_LNA, COV77_LNA, COV81_LNA, COV82_LNA, COV83_LNA, COV84_LNA, COV85_LNA, COV86_LNA, COV87_LNA, COV88_LNA, STAT_CORR_EMRE, pSTAT_CORR_EMRE, pSTAT_pSTAT_CORR_EMRE, nSTAT1_CORR_EMRE, nSTAT2_CORR_EMRE, nSTAT3_CORR_EMRE, nSTAT4_CORR_EMRE, nSTAT5_CORR_EMRE ...
];

% PARAMETERS

syms p1 p2 p3 p4 init_STAT Omega_cyt Omega_nuc sp1 sp2 sp3 sp4 sp5 offset_tSTAT offset_pSTAT scale_tSTAT scale_pSTAT

p = [p1,p2,p3,p4,init_STAT,sp1,sp2,sp3,sp4,sp5,offset_tSTAT,offset_pSTAT,scale_tSTAT,scale_pSTAT];

k = [Omega_cyt,Omega_nuc];
% INPUT 

syms t
u(1) = spline_pos5(t, 0.0, sp1, 5.0, sp2, 10.0, sp3, 20.0, sp4, 60.0, sp5, 0, 0.0);

% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

xdot(1) = (Omega_nuc*nSTAT5*p4 - Omega_cyt*STAT*p1*u(1))/Omega_cyt;
xdot(2) = -(2*p2*pSTAT^2 - STAT*init_STAT*p1*u(1))/init_STAT;
xdot(3) = (p2*pSTAT^2 - init_STAT*p3*pSTAT_pSTAT)/init_STAT;
xdot(4) = -(p4*(Omega_cyt*STAT - Omega_cyt*init_STAT + 2*Omega_nuc*nSTAT1 + Omega_nuc*nSTAT2 + Omega_nuc*nSTAT3 + Omega_nuc*nSTAT4 + Omega_nuc*nSTAT5 + Omega_cyt*pSTAT + 2*Omega_cyt*pSTAT_pSTAT))/Omega_nuc;
xdot(5) = p4*(nSTAT1 - nSTAT2);
xdot(6) = p4*(nSTAT2 - nSTAT3);
xdot(7) = p4*(nSTAT3 - nSTAT4);
xdot(8) = p4*(nSTAT4 - nSTAT5);
xdot(9) = (Omega_nuc*nSTAT5*p4 - 2*COV11_LNA*Omega_cyt^2*p1*u(1) + 2*COV81_LNA*Omega_nuc*Omega_cyt*p4 + Omega_cyt*STAT*p1*u(1))/Omega_cyt^2;
xdot(10) = -(4*COV21_LNA*Omega_cyt*p2*pSTAT - COV82_LNA*Omega_nuc*init_STAT*p4 + STAT*init_STAT*p1*u(1) - COV11_LNA*Omega_cyt*init_STAT*p1*u(1) + COV21_LNA*Omega_cyt*init_STAT*p1*u(1))/(Omega_cyt*init_STAT);
xdot(11) = (4*p2*pSTAT^2 - 8*COV22_LNA*Omega_cyt*p2*pSTAT + STAT*init_STAT*p1*u(1) + 2*COV21_LNA*Omega_cyt*init_STAT*p1*u(1))/(Omega_cyt*init_STAT);
xdot(12) = -(COV31_LNA*Omega_cyt^2*p3 + COV31_LNA*Omega_cyt^2*p1*u(1) - COV83_LNA*Omega_nuc*Omega_cyt*p4 - (2*COV21_LNA*Omega_cyt^2*p2*pSTAT)/init_STAT)/Omega_cyt^2;
xdot(13) = -(2*p2*pSTAT^2 + COV32_LNA*Omega_cyt*init_STAT*p3 - 2*COV22_LNA*Omega_cyt*p2*pSTAT + 4*COV32_LNA*Omega_cyt*p2*pSTAT - COV31_LNA*Omega_cyt*init_STAT*p1*u(1))/(Omega_cyt*init_STAT);
xdot(14) = (p2*pSTAT^2 + init_STAT*p3*pSTAT_pSTAT - 2*COV33_LNA*Omega_cyt*init_STAT*p3 + 4*COV32_LNA*Omega_cyt*p2*pSTAT)/(Omega_cyt*init_STAT);
xdot(15) = -(COV11_LNA*Omega_cyt^2*p4 + COV21_LNA*Omega_cyt^2*p4 + 2*COV31_LNA*Omega_cyt^2*p4 - COV84_LNA*Omega_nuc^2*p4 + 2*COV41_LNA*Omega_nuc*Omega_cyt*p4 + COV51_LNA*Omega_nuc*Omega_cyt*p4 + COV61_LNA*Omega_nuc*Omega_cyt*p4 + COV71_LNA*Omega_nuc*Omega_cyt*p4 + COV81_LNA*Omega_nuc*Omega_cyt*p4 + COV41_LNA*Omega_nuc*Omega_cyt*p1*u(1))/(Omega_nuc*Omega_cyt);
xdot(16) = -(COV21_LNA*Omega_cyt*init_STAT*p4 + COV22_LNA*Omega_cyt*init_STAT*p4 + 2*COV32_LNA*Omega_cyt*init_STAT*p4 + 2*COV42_LNA*Omega_nuc*init_STAT*p4 + COV52_LNA*Omega_nuc*init_STAT*p4 + COV62_LNA*Omega_nuc*init_STAT*p4 + COV72_LNA*Omega_nuc*init_STAT*p4 + COV82_LNA*Omega_nuc*init_STAT*p4 + 4*COV42_LNA*Omega_nuc*p2*pSTAT - COV41_LNA*Omega_nuc*init_STAT*p1*u(1))/(Omega_nuc*init_STAT);
xdot(17) = -(COV31_LNA*Omega_cyt*init_STAT*p4 + COV32_LNA*Omega_cyt*init_STAT*p4 + COV43_LNA*Omega_nuc*init_STAT*p3 + 2*COV33_LNA*Omega_cyt*init_STAT*p4 + 2*COV43_LNA*Omega_nuc*init_STAT*p4 + COV53_LNA*Omega_nuc*init_STAT*p4 + COV63_LNA*Omega_nuc*init_STAT*p4 + COV73_LNA*Omega_nuc*init_STAT*p4 + COV83_LNA*Omega_nuc*init_STAT*p4 - 2*COV42_LNA*Omega_nuc*p2*pSTAT)/(Omega_nuc*init_STAT);
xdot(18) = -(p4*(2*Omega_cyt*STAT - 2*Omega_cyt*init_STAT + Omega_nuc*nSTAT1 + 2*Omega_nuc*nSTAT2 + 2*Omega_nuc*nSTAT3 + 2*Omega_nuc*nSTAT4 + 2*Omega_nuc*nSTAT5 + 2*Omega_cyt*pSTAT + 4*Omega_cyt*pSTAT_pSTAT + 4*COV44_LNA*Omega_nuc^2 + 2*COV54_LNA*Omega_nuc^2 + 2*COV64_LNA*Omega_nuc^2 + 2*COV74_LNA*Omega_nuc^2 + 2*COV84_LNA*Omega_nuc^2 + 2*COV41_LNA*Omega_nuc*Omega_cyt + 2*COV42_LNA*Omega_nuc*Omega_cyt + 4*COV43_LNA*Omega_nuc*Omega_cyt))/Omega_nuc^2;
xdot(19) = (COV41_LNA*Omega_cyt*p4 - COV51_LNA*Omega_cyt*p4 + COV85_LNA*Omega_nuc*p4 - COV51_LNA*Omega_cyt*p1*u(1))/Omega_cyt;
xdot(20) = (COV42_LNA*init_STAT*p4 - COV52_LNA*init_STAT*p4 - 4*COV52_LNA*p2*pSTAT + COV51_LNA*init_STAT*p1*u(1))/init_STAT;
xdot(21) = (COV43_LNA*init_STAT*p4 - COV53_LNA*init_STAT*p3 - COV53_LNA*init_STAT*p4 + 2*COV52_LNA*p2*pSTAT)/init_STAT;
xdot(22) = -(p4*(nSTAT1 - COV44_LNA*Omega_nuc + 3*COV54_LNA*Omega_nuc + COV55_LNA*Omega_nuc + COV51_LNA*Omega_cyt + COV52_LNA*Omega_cyt + 2*COV53_LNA*Omega_cyt + COV65_LNA*Omega_nuc + COV75_LNA*Omega_nuc + COV85_LNA*Omega_nuc))/Omega_nuc;
xdot(23) = (p4*(nSTAT1 + nSTAT2 + 2*COV54_LNA*Omega_nuc - 2*COV55_LNA*Omega_nuc))/Omega_nuc;
xdot(24) = (COV51_LNA*Omega_cyt*p4 - COV61_LNA*Omega_cyt*p4 + COV86_LNA*Omega_nuc*p4 - COV61_LNA*Omega_cyt*p1*u(1))/Omega_cyt;
xdot(25) = (COV52_LNA*init_STAT*p4 - COV62_LNA*init_STAT*p4 - 4*COV62_LNA*p2*pSTAT + COV61_LNA*init_STAT*p1*u(1))/init_STAT;
xdot(26) = (COV53_LNA*init_STAT*p4 - COV63_LNA*init_STAT*p3 - COV63_LNA*init_STAT*p4 + 2*COV62_LNA*p2*pSTAT)/init_STAT;
xdot(27) = -(p4*(3*COV64_LNA*Omega_nuc - COV54_LNA*Omega_nuc + COV65_LNA*Omega_nuc + COV66_LNA*Omega_nuc + COV61_LNA*Omega_cyt + COV62_LNA*Omega_cyt + 2*COV63_LNA*Omega_cyt + COV76_LNA*Omega_nuc + COV86_LNA*Omega_nuc))/Omega_nuc;
xdot(28) = -(p4*(nSTAT2 - COV55_LNA*Omega_nuc - COV64_LNA*Omega_nuc + 2*COV65_LNA*Omega_nuc))/Omega_nuc;
xdot(29) = (p4*(nSTAT2 + nSTAT3 + 2*COV65_LNA*Omega_nuc - 2*COV66_LNA*Omega_nuc))/Omega_nuc;
xdot(30) = (COV61_LNA*Omega_cyt*p4 - COV71_LNA*Omega_cyt*p4 + COV87_LNA*Omega_nuc*p4 - COV71_LNA*Omega_cyt*p1*u(1))/Omega_cyt;
xdot(31) = (COV62_LNA*init_STAT*p4 - COV72_LNA*init_STAT*p4 - 4*COV72_LNA*p2*pSTAT + COV71_LNA*init_STAT*p1*u(1))/init_STAT;
xdot(32) = (COV63_LNA*init_STAT*p4 - COV73_LNA*init_STAT*p3 - COV73_LNA*init_STAT*p4 + 2*COV72_LNA*p2*pSTAT)/init_STAT;
xdot(33) = -(p4*(3*COV74_LNA*Omega_nuc - COV64_LNA*Omega_nuc + COV75_LNA*Omega_nuc + COV76_LNA*Omega_nuc + COV77_LNA*Omega_nuc + COV71_LNA*Omega_cyt + COV72_LNA*Omega_cyt + 2*COV73_LNA*Omega_cyt + COV87_LNA*Omega_nuc))/Omega_nuc;
xdot(34) = p4*(COV65_LNA + COV74_LNA - 2*COV75_LNA);
xdot(35) = -(p4*(nSTAT3 - COV66_LNA*Omega_nuc - COV75_LNA*Omega_nuc + 2*COV76_LNA*Omega_nuc))/Omega_nuc;
xdot(36) = (p4*(nSTAT3 + nSTAT4 + 2*COV76_LNA*Omega_nuc - 2*COV77_LNA*Omega_nuc))/Omega_nuc;
xdot(37) = -(nSTAT5*p4 - COV71_LNA*Omega_cyt*p4 - COV88_LNA*Omega_nuc*p4 + COV81_LNA*Omega_cyt*p4 + COV81_LNA*Omega_cyt*p1*u(1))/Omega_cyt;
xdot(38) = (COV72_LNA*init_STAT*p4 - COV82_LNA*init_STAT*p4 - 4*COV82_LNA*p2*pSTAT + COV81_LNA*init_STAT*p1*u(1))/init_STAT;
xdot(39) = (COV73_LNA*init_STAT*p4 - COV83_LNA*init_STAT*p3 - COV83_LNA*init_STAT*p4 + 2*COV82_LNA*p2*pSTAT)/init_STAT;
xdot(40) = -(p4*(3*COV84_LNA*Omega_nuc - COV74_LNA*Omega_nuc + COV85_LNA*Omega_nuc + COV86_LNA*Omega_nuc + COV87_LNA*Omega_nuc + COV88_LNA*Omega_nuc + COV81_LNA*Omega_cyt + COV82_LNA*Omega_cyt + 2*COV83_LNA*Omega_cyt))/Omega_nuc;
xdot(41) = p4*(COV75_LNA + COV84_LNA - 2*COV85_LNA);
xdot(42) = p4*(COV76_LNA + COV85_LNA - 2*COV86_LNA);
xdot(43) = -(p4*(nSTAT4 - COV77_LNA*Omega_nuc - COV86_LNA*Omega_nuc + 2*COV87_LNA*Omega_nuc))/Omega_nuc;
xdot(44) = (p4*(nSTAT4 + nSTAT5 + 2*COV87_LNA*Omega_nuc - 2*COV88_LNA*Omega_nuc))/Omega_nuc;
xdot(45) = (Omega_nuc*nSTAT5_CORR_EMRE*p4 - Omega_cyt*STAT_CORR_EMRE*p1*u(1))/Omega_cyt;
xdot(46) = -(2*COV22_LNA*p2 + 4*p2*pSTAT*pSTAT_CORR_EMRE - STAT_CORR_EMRE*init_STAT*p1*u(1))/init_STAT;
xdot(47) = (COV22_LNA*p2 - init_STAT*p3*pSTAT_pSTAT_CORR_EMRE + 2*p2*pSTAT*pSTAT_CORR_EMRE)/init_STAT;
xdot(48) = -(p4*(Omega_cyt*STAT_CORR_EMRE + 2*Omega_nuc*nSTAT1_CORR_EMRE + Omega_nuc*nSTAT2_CORR_EMRE + Omega_nuc*nSTAT3_CORR_EMRE + Omega_nuc*nSTAT4_CORR_EMRE + Omega_nuc*nSTAT5_CORR_EMRE + Omega_cyt*pSTAT_CORR_EMRE + 2*Omega_cyt*pSTAT_pSTAT_CORR_EMRE))/Omega_nuc;
xdot(49) = p4*(nSTAT1_CORR_EMRE - nSTAT2_CORR_EMRE);
xdot(50) = p4*(nSTAT2_CORR_EMRE - nSTAT3_CORR_EMRE);
xdot(51) = p4*(nSTAT3_CORR_EMRE - nSTAT4_CORR_EMRE);
xdot(52) = p4*(nSTAT4_CORR_EMRE - nSTAT5_CORR_EMRE);
% INITIAL CONDITIONS

x0 = sym(zeros(size(x)));

x0(1) = init_STAT;

% OBSERVABLES

y = sym(zeros(3,1));

y(1) = offset_pSTAT + scale_pSTAT/init_STAT*(pSTAT + pSTAT_CORR_EMRE + 2*(pSTAT_pSTAT + pSTAT_pSTAT_CORR_EMRE));
y(2) = offset_tSTAT + scale_tSTAT/init_STAT*(STAT + STAT_CORR_EMRE + pSTAT + pSTAT_CORR_EMRE + 2*(pSTAT_pSTAT + pSTAT_pSTAT_CORR_EMRE));
y(3) = u(1);

% SYSTEM STRUCT

model.sym.x = x;
model.sym.u = u;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.k = k;
model.sym.x0 = x0;
model.sym.y = y;
end