function [model] = MEC_2_LD_2_c_f_JakStat_red_syms()

% CVODES OPTIONS

model.atol = 1e-12;
model.rtol = 1e-8;
model.maxsteps = 1e4;
model.param = 'log10';

% STATES

syms mu_1 mu_2 mu_3 mu_4 mu_5 mu_6 mu_7 mu_8 C_1_1 C_1_2 C_1_3 C_1_4 C_1_5 C_1_6 C_1_7 C_1_8 C_2_2 C_2_3 C_2_4 C_2_5 C_2_6 C_2_7 C_2_8 C_3_3 C_3_4 C_3_5 C_3_6 C_3_7 C_3_8 C_4_4 C_4_5 C_4_6 C_4_7 C_4_8 C_5_5 C_5_6 C_5_7 C_5_8 C_6_6 C_6_7 C_6_8 C_7_7 C_7_8 C_8_8

x = [
mu_1, mu_2, mu_3, mu_4, mu_5, mu_6, mu_7, mu_8, C_1_1, C_1_2, C_1_3, C_1_4, C_1_5, C_1_6, C_1_7, C_1_8, C_2_2, C_2_3, C_2_4, C_2_5, C_2_6, C_2_7, C_2_8, C_3_3, C_3_4, C_3_5, C_3_6, C_3_7, C_3_8, C_4_4, C_4_5, C_4_6, C_4_7, C_4_8, C_5_5, C_5_6, C_5_7, C_5_8, C_6_6, C_6_7, C_6_8, C_7_7, C_7_8, C_8_8 ...
];

% PARAMETERS

syms p1 p2 p3 p4 init_STAT Omega_cyt Omega_nuc sp1 sp2 sp3 sp4 sp5 offset_tSTAT offset_pSTAT scale_tSTAT scale_pSTAT

p = [p1,p2,p3,p4,init_STAT,sp1,sp2,sp3,sp4,sp5,offset_tSTAT,offset_pSTAT,scale_tSTAT,scale_pSTAT];

k = [Omega_cyt,Omega_nuc];

% INPUT 
syms t
u(1) = spline_pos5(t, 0.0, sp1, 5.0, sp2, 10.0, sp3, 20.0, sp4, 60.0, sp5, 0, 0.0);

% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

xdot(1) = (Omega_nuc*mu_8*p4 - Omega_cyt*mu_1*p1*u(1))/Omega_cyt;
xdot(2) = -((C_2_2*Omega_cyt*p2)/init_STAT + (mu_2*p2*(Omega_cyt*mu_2 - 1))/init_STAT - Omega_cyt*mu_1*p1*u(1))/Omega_cyt;
xdot(3) = ((C_2_2*Omega_cyt*p2)/(2*init_STAT) - Omega_cyt*mu_3*p3 + (mu_2*p2*(Omega_cyt*mu_2 - 1))/(2*init_STAT))/Omega_cyt;
xdot(4) = -(p4*(2*Omega_nuc*mu_4 - Omega_cyt*init_STAT + Omega_nuc*mu_5 + Omega_nuc*mu_6 + Omega_nuc*mu_7 + Omega_nuc*mu_8 + Omega_cyt*mu_1 + Omega_cyt*mu_2 + 2*Omega_cyt*mu_3))/Omega_nuc;
xdot(5) = p4*(mu_4 - mu_5);
xdot(6) = p4*(mu_5 - mu_6);
xdot(7) = p4*(mu_6 - mu_7);
xdot(8) = p4*(mu_7 - mu_8);
xdot(9) = (Omega_nuc*mu_8*p4 - 2*C_1_1*Omega_cyt^2*p1*u(1) + 2*C_1_8*Omega_nuc*Omega_cyt*p4 + Omega_cyt*mu_1*p1*u(1))/Omega_cyt^2;
xdot(10) = -(C_1_2*Omega_cyt^2*p1*u(1) - C_1_1*Omega_cyt^2*p1*u(1) - C_2_8*Omega_nuc*Omega_cyt*p4 + Omega_cyt*mu_1*p1*u(1) + (C_1_2*Omega_cyt*p2*(2*Omega_cyt*mu_2 - 1))/init_STAT)/Omega_cyt^2;
xdot(11) = -(C_1_3*Omega_cyt^2*p3 + C_1_3*Omega_cyt^2*p1*u(1) - C_3_8*Omega_nuc*Omega_cyt*p4 - (C_1_2*Omega_cyt*p2*(2*Omega_cyt*mu_2 - 1))/(2*init_STAT))/Omega_cyt^2;
xdot(12) = -(C_1_1*Omega_cyt^2*p4 + C_1_2*Omega_cyt^2*p4 + 2*C_1_3*Omega_cyt^2*p4 - C_4_8*Omega_nuc^2*p4 + 2*C_1_4*Omega_nuc*Omega_cyt*p4 + C_1_5*Omega_nuc*Omega_cyt*p4 + C_1_6*Omega_nuc*Omega_cyt*p4 + C_1_7*Omega_nuc*Omega_cyt*p4 + C_1_8*Omega_nuc*Omega_cyt*p4 + C_1_4*Omega_nuc*Omega_cyt*p1*u(1))/(Omega_nuc*Omega_cyt);
xdot(13) = (C_1_4*Omega_cyt*p4 - C_1_5*Omega_cyt*p4 + C_5_8*Omega_nuc*p4 - C_1_5*Omega_cyt*p1*u(1))/Omega_cyt;
xdot(14) = (C_1_5*Omega_cyt*p4 - C_1_6*Omega_cyt*p4 + C_6_8*Omega_nuc*p4 - C_1_6*Omega_cyt*p1*u(1))/Omega_cyt;
xdot(15) = (C_1_6*Omega_cyt*p4 - C_1_7*Omega_cyt*p4 + C_7_8*Omega_nuc*p4 - C_1_7*Omega_cyt*p1*u(1))/Omega_cyt;
xdot(16) = -(mu_8*p4 - C_1_7*Omega_cyt*p4 + C_1_8*Omega_cyt*p4 - C_8_8*Omega_nuc*p4 + C_1_8*Omega_cyt*p1*u(1))/Omega_cyt;
xdot(17) = (4*C_2_2*Omega_cyt*p2 - 2*mu_2*p2 + 2*Omega_cyt*mu_2^2*p2 - 4*C_2_2*Omega_cyt^2*mu_2*p2 + Omega_cyt*init_STAT*mu_1*p1*u(1) + 2*C_1_2*Omega_cyt^2*init_STAT*p1*u(1))/(Omega_cyt^2*init_STAT);
xdot(18) = (2*mu_2*p2 - 3*C_2_2*Omega_cyt*p2 + 2*C_2_3*Omega_cyt*p2 - 2*Omega_cyt*mu_2^2*p2 - 2*C_2_3*Omega_cyt^2*init_STAT*p3 + 2*C_2_2*Omega_cyt^2*mu_2*p2 - 4*C_2_3*Omega_cyt^2*mu_2*p2 + 2*C_1_3*Omega_cyt^2*init_STAT*p1*u(1))/(2*Omega_cyt^2*init_STAT);
xdot(19) = -(C_1_2*Omega_cyt^2*p4 + C_2_2*Omega_cyt^2*p4 + 2*C_2_3*Omega_cyt^2*p4 + 2*C_2_4*Omega_nuc*Omega_cyt*p4 + C_2_5*Omega_nuc*Omega_cyt*p4 + C_2_6*Omega_nuc*Omega_cyt*p4 + C_2_7*Omega_nuc*Omega_cyt*p4 + C_2_8*Omega_nuc*Omega_cyt*p4 - C_1_4*Omega_nuc*Omega_cyt*p1*u(1) + (C_2_4*Omega_nuc*p2*(2*Omega_cyt*mu_2 - 1))/init_STAT)/(Omega_nuc*Omega_cyt);
xdot(20) = (C_2_5*p2 + C_2_4*Omega_cyt*init_STAT*p4 - C_2_5*Omega_cyt*init_STAT*p4 - 2*C_2_5*Omega_cyt*mu_2*p2 + C_1_5*Omega_cyt*init_STAT*p1*u(1))/(Omega_cyt*init_STAT);
xdot(21) = (C_2_6*p2 + C_2_5*Omega_cyt*init_STAT*p4 - C_2_6*Omega_cyt*init_STAT*p4 - 2*C_2_6*Omega_cyt*mu_2*p2 + C_1_6*Omega_cyt*init_STAT*p1*u(1))/(Omega_cyt*init_STAT);
xdot(22) = (C_2_7*p2 + C_2_6*Omega_cyt*init_STAT*p4 - C_2_7*Omega_cyt*init_STAT*p4 - 2*C_2_7*Omega_cyt*mu_2*p2 + C_1_7*Omega_cyt*init_STAT*p1*u(1))/(Omega_cyt*init_STAT);
xdot(23) = (C_2_8*p2 + C_2_7*Omega_cyt*init_STAT*p4 - C_2_8*Omega_cyt*init_STAT*p4 - 2*C_2_8*Omega_cyt*mu_2*p2 + C_1_8*Omega_cyt*init_STAT*p1*u(1))/(Omega_cyt*init_STAT);
xdot(24) = (Omega_cyt*mu_3*p3 - 2*C_3_3*Omega_cyt^2*p3 + (C_2_2*Omega_cyt*p2)/(2*init_STAT) + (mu_2*p2*(Omega_cyt*mu_2 - 1))/(2*init_STAT) + (C_2_3*Omega_cyt*p2*(2*Omega_cyt*mu_2 - 1))/init_STAT)/Omega_cyt^2;
xdot(25) = -(C_1_3*Omega_cyt^2*p4 + C_2_3*Omega_cyt^2*p4 + 2*C_3_3*Omega_cyt^2*p4 + C_3_4*Omega_nuc*Omega_cyt*p3 + 2*C_3_4*Omega_nuc*Omega_cyt*p4 + C_3_5*Omega_nuc*Omega_cyt*p4 + C_3_6*Omega_nuc*Omega_cyt*p4 + C_3_7*Omega_nuc*Omega_cyt*p4 + C_3_8*Omega_nuc*Omega_cyt*p4 - (C_2_4*Omega_nuc*p2*(2*Omega_cyt*mu_2 - 1))/(2*init_STAT))/(Omega_nuc*Omega_cyt);
xdot(26) = -(C_2_5*p2 - 2*C_3_4*Omega_cyt*init_STAT*p4 + 2*C_3_5*Omega_cyt*init_STAT*p3 + 2*C_3_5*Omega_cyt*init_STAT*p4 - 2*C_2_5*Omega_cyt*mu_2*p2)/(2*Omega_cyt*init_STAT);
xdot(27) = -(C_2_6*p2 - 2*C_3_5*Omega_cyt*init_STAT*p4 + 2*C_3_6*Omega_cyt*init_STAT*p3 + 2*C_3_6*Omega_cyt*init_STAT*p4 - 2*C_2_6*Omega_cyt*mu_2*p2)/(2*Omega_cyt*init_STAT);
xdot(28) = -(C_2_7*p2 - 2*C_3_6*Omega_cyt*init_STAT*p4 + 2*C_3_7*Omega_cyt*init_STAT*p3 + 2*C_3_7*Omega_cyt*init_STAT*p4 - 2*C_2_7*Omega_cyt*mu_2*p2)/(2*Omega_cyt*init_STAT);
xdot(29) = -(C_2_8*p2 - 2*C_3_7*Omega_cyt*init_STAT*p4 + 2*C_3_8*Omega_cyt*init_STAT*p3 + 2*C_3_8*Omega_cyt*init_STAT*p4 - 2*C_2_8*Omega_cyt*mu_2*p2)/(2*Omega_cyt*init_STAT);
xdot(30) = -(p4*(Omega_nuc*mu_4 - 2*Omega_cyt*init_STAT + 2*Omega_nuc*mu_5 + 2*Omega_nuc*mu_6 + 2*Omega_nuc*mu_7 + 2*Omega_nuc*mu_8 + 2*Omega_cyt*mu_1 + 2*Omega_cyt*mu_2 + 4*Omega_cyt*mu_3 + 4*C_4_4*Omega_nuc^2 + 2*C_4_5*Omega_nuc^2 + 2*C_4_6*Omega_nuc^2 + 2*C_4_7*Omega_nuc^2 + 2*C_4_8*Omega_nuc^2 + 2*C_1_4*Omega_nuc*Omega_cyt + 2*C_2_4*Omega_nuc*Omega_cyt + 4*C_3_4*Omega_nuc*Omega_cyt))/Omega_nuc^2;
xdot(31) = -(p4*(mu_4 + C_1_5*Omega_cyt + C_2_5*Omega_cyt - C_4_4*Omega_nuc + 2*C_3_5*Omega_cyt + 3*C_4_5*Omega_nuc + C_5_5*Omega_nuc + C_5_6*Omega_nuc + C_5_7*Omega_nuc + C_5_8*Omega_nuc))/Omega_nuc;
xdot(32) = -(p4*(C_1_6*Omega_cyt + C_2_6*Omega_cyt - C_4_5*Omega_nuc + 2*C_3_6*Omega_cyt + 3*C_4_6*Omega_nuc + C_5_6*Omega_nuc + C_6_6*Omega_nuc + C_6_7*Omega_nuc + C_6_8*Omega_nuc))/Omega_nuc;
xdot(33) = -(p4*(C_1_7*Omega_cyt + C_2_7*Omega_cyt - C_4_6*Omega_nuc + 2*C_3_7*Omega_cyt + 3*C_4_7*Omega_nuc + C_5_7*Omega_nuc + C_6_7*Omega_nuc + C_7_7*Omega_nuc + C_7_8*Omega_nuc))/Omega_nuc;
xdot(34) = -(p4*(C_1_8*Omega_cyt + C_2_8*Omega_cyt - C_4_7*Omega_nuc + 2*C_3_8*Omega_cyt + 3*C_4_8*Omega_nuc + C_5_8*Omega_nuc + C_6_8*Omega_nuc + C_7_8*Omega_nuc + C_8_8*Omega_nuc))/Omega_nuc;
xdot(35) = (p4*(mu_4 + mu_5 + 2*C_4_5*Omega_nuc - 2*C_5_5*Omega_nuc))/Omega_nuc;
xdot(36) = -(p4*(mu_5 - C_4_6*Omega_nuc - C_5_5*Omega_nuc + 2*C_5_6*Omega_nuc))/Omega_nuc;
xdot(37) = p4*(C_4_7 + C_5_6 - 2*C_5_7);
xdot(38) = p4*(C_4_8 + C_5_7 - 2*C_5_8);
xdot(39) = (p4*(mu_5 + mu_6 + 2*C_5_6*Omega_nuc - 2*C_6_6*Omega_nuc))/Omega_nuc;
xdot(40) = -(p4*(mu_6 - C_5_7*Omega_nuc - C_6_6*Omega_nuc + 2*C_6_7*Omega_nuc))/Omega_nuc;
xdot(41) = p4*(C_5_8 + C_6_7 - 2*C_6_8);
xdot(42) = (p4*(mu_6 + mu_7 + 2*C_6_7*Omega_nuc - 2*C_7_7*Omega_nuc))/Omega_nuc;
xdot(43) = -(p4*(mu_7 - C_6_8*Omega_nuc - C_7_7*Omega_nuc + 2*C_7_8*Omega_nuc))/Omega_nuc;
xdot(44) = (p4*(mu_7 + mu_8 + 2*C_7_8*Omega_nuc - 2*C_8_8*Omega_nuc))/Omega_nuc;
% INITIAL CONDITIONS

x0 = sym(zeros(size(x)));

x0(1) = init_STAT;
x0(2) = 0;
x0(3) = 0;
x0(4) = 0;
x0(5) = 0;
x0(6) = 0;
x0(7) = 0;
x0(8) = 0;
x0(9) = 0;
x0(10) = 0;
x0(11) = 0;
x0(12) = 0;
x0(13) = 0;
x0(14) = 0;
x0(15) = 0;
x0(16) = 0;
x0(17) = 0;
x0(18) = 0;
x0(19) = 0;
x0(20) = 0;
x0(21) = 0;
x0(22) = 0;
x0(23) = 0;
x0(24) = 0;
x0(25) = 0;
x0(26) = 0;
x0(27) = 0;
x0(28) = 0;
x0(29) = 0;
x0(30) = 0;
x0(31) = 0;
x0(32) = 0;
x0(33) = 0;
x0(34) = 0;
x0(35) = 0;
x0(36) = 0;
x0(37) = 0;
x0(38) = 0;
x0(39) = 0;
x0(40) = 0;
x0(41) = 0;
x0(42) = 0;
x0(43) = 0;
x0(44) = 0;

% OBSERVABLES

y = sym(zeros(3,1));

y(1) = offset_pSTAT + scale_pSTAT/init_STAT*(mu_2 + 2*mu_3)/Omega_cyt;
y(2) = offset_tSTAT + scale_tSTAT/init_STAT*(mu_1 + mu_2 + 2*mu_3)/Omega_cyt;
y(3) = u(1);

% SYSTEM STRUCT

model.sym.x = x;
model.sym.u = u;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.k = k;
model.sym.x0 = x0;
model.sym.y = y;
end