function [model] = MEC_2_LD_2_c_f_trimerization_syms()

% CVODES OPTIONS

model.atol = 1e-8;
model.rtol = 1e-8;
model.maxsteps = 1e4;

% STATES

syms mu_1 mu_2 mu_3 C_1_1 C_1_2 C_1_3 C_2_2 C_2_3 C_3_3

x = [
mu_1, mu_2, mu_3, C_1_1, C_1_2, C_1_3, C_2_2, C_2_3, C_3_3 ...
];

% PARAMETERS

syms k0 k1 k1m k2 k3 k4 Omega 

p = [k0,k1,k1m,k2,k3,k4,Omega];

% INPUT 

u = sym.empty(0,0);

% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

xdot(1) = -(2*C_1_1*Omega*k1 - 30*Omega*k0 + C_1_2*Omega*k1m + Omega*k2*mu_1 + 2*k1*mu_1*(Omega*mu_1 - 1) + Omega*k1m*mu_1*mu_2)/Omega;
xdot(2) = -(C_1_2*Omega*k1m - C_1_1*Omega*k1 + Omega*k3*mu_2 - k1*mu_1*(Omega*mu_1 - 1) + Omega*k1m*mu_1*mu_2)/Omega;
xdot(3) = C_1_2*k1m - k4*mu_3 + k1m*mu_1*mu_2;
xdot(4) = (900*Omega*k0 + 4*C_1_1*Omega*k1 + C_1_2*Omega*k1m + Omega*k2*mu_1 + 4*k1*mu_1*(Omega*mu_1 - 1) - 2*C_1_1*Omega^2*k2 - 2*C_1_1*Omega^2*k1m*mu_2 - 2*C_1_2*Omega^2*k1m*mu_1 - 4*C_1_1*Omega*k1*(2*Omega*mu_1 - 1) + Omega*k1m*mu_1*mu_2)/Omega^2;
xdot(5) = -(2*C_1_1*Omega*k1 - C_1_2*Omega*k1m + 2*k1*mu_1*(Omega*mu_1 - 1) + C_1_2*Omega^2*k2 + C_1_2*Omega^2*k3 + C_1_1*Omega^2*k1m*mu_2 + C_1_2*Omega^2*k1m*mu_1 + C_1_2*Omega^2*k1m*mu_2 + C_2_2*Omega^2*k1m*mu_1 - C_1_1*Omega*k1*(2*Omega*mu_1 - 1) + 2*C_1_2*Omega*k1*(2*Omega*mu_1 - 1) - Omega*k1m*mu_1*mu_2)/Omega^2;
xdot(6) = -(C_1_2*k1m - 2*C_1_3*k1 + C_1_3*Omega*k2 + C_1_3*Omega*k4 + k1m*mu_1*mu_2 + 4*C_1_3*Omega*k1*mu_1 - C_1_1*Omega*k1m*mu_2 - C_1_2*Omega*k1m*mu_1 + C_1_3*Omega*k1m*mu_2 + C_2_3*Omega*k1m*mu_1)/Omega;
xdot(7) = (C_1_1*Omega*k1 + C_1_2*Omega*k1m + Omega*k3*mu_2 + k1*mu_1*(Omega*mu_1 - 1) - 2*C_2_2*Omega^2*k3 - 2*C_1_2*Omega^2*k1m*mu_2 - 2*C_2_2*Omega^2*k1m*mu_1 + 2*C_1_2*Omega*k1*(2*Omega*mu_1 - 1) + Omega*k1m*mu_1*mu_2)/Omega^2;
xdot(8) = -(C_1_3*k1 + C_1_2*k1m + C_2_3*Omega*k3 + C_2_3*Omega*k4 + k1m*mu_1*mu_2 - 2*C_1_3*Omega*k1*mu_1 - C_1_2*Omega*k1m*mu_2 + C_1_3*Omega*k1m*mu_2 - C_2_2*Omega*k1m*mu_1 + C_2_3*Omega*k1m*mu_1)/Omega;
xdot(9) = (C_1_2*k1m + k4*mu_3 - 2*C_3_3*Omega*k4 + k1m*mu_1*mu_2 + 2*C_1_3*Omega*k1m*mu_2 + 2*C_2_3*Omega*k1m*mu_1)/Omega;
% INITIAL CONDITIONS

x0 = sym(zeros(size(x)));

x0(1) = 0;
x0(2) = 0;
x0(3) = 0;
x0(4) = 0;
x0(5) = 0;
x0(6) = 0;
x0(7) = 0;
x0(8) = 0;
x0(9) = 0;

% OBSERVABLES

y = sym(zeros(6,1));

y(1) = mu_1;
y(2) = mu_2;
y(3) = mu_3;
y(4) = C_1_1;
y(5) = C_2_2;
y(6) = C_3_3;


% SYSTEM STRUCT

model.sym.x = x;
model.sym.u = u;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end