function [model] = MEC_3_LD_3_enzyme_syms()

% CVODES OPTIONS

model.atol = 1e-8;
model.rtol = 1e-8;
model.maxsteps = 1e4;

% STATES

syms mu_1 mu_2 mu_3 C_1_1 C_1_2 C_1_3 C_2_2 C_2_3 C_3_3 C_1_1_1 C_1_1_2 C_1_1_3 C_1_2_2 C_1_2_3 C_1_3_3 C_2_2_2 C_2_2_3 C_2_3_3 C_3_3_3

x = [
mu_1, mu_2, mu_3, C_1_1, C_1_2, C_1_3, C_2_2, C_2_3, C_3_3, C_1_1_1, C_1_1_2, C_1_1_3, C_1_2_2, C_1_2_3, C_1_3_3, C_2_2_2, C_2_2_3, C_2_3_3, C_3_3_3 ...
];

% PARAMETERS

syms k2 k0 kdm ks k1 km2 cE0 Omega 

p = [k2,k0,kdm,ks,k1,km2,cE0,Omega];

% INPUT 

u = sym.empty(0,0);

% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

xdot(1) = k0 - kdm*mu_1;
xdot(2) = cE0*km2 - C_2_3*k1 - km2*mu_3 + ks*mu_1 - k1*mu_2*mu_3;
xdot(3) = cE0*k2 - C_2_3*k1 + cE0*km2 - k2*mu_3 - km2*mu_3 - k1*mu_2*mu_3;
xdot(4) = (k0 + kdm*mu_1 - 2*C_1_1*Omega*kdm)/Omega;
xdot(5) = C_1_1*ks - C_1_2*kdm - C_1_3*km2 - C_1_2_3*k1 - C_1_2*k1*mu_3 - C_1_3*k1*mu_2;
xdot(6) = - C_1_3*k2 - C_1_2_3*k1 - C_1_3*kdm - C_1_3*km2 - C_1_2*k1*mu_3 - C_1_3*k1*mu_2;
xdot(7) = (C_2_3*k1 + cE0*km2 - km2*mu_3 + ks*mu_1 - 2*C_2_2_3*Omega*k1 - 2*C_2_3*Omega*km2 + 2*C_1_2*Omega*ks + k1*mu_2*mu_3 - 2*C_2_2*Omega*k1*mu_3 - 2*C_2_3*Omega*k1*mu_2)/Omega;
xdot(8) = -(km2*mu_3 - cE0*km2 - C_2_3*k1 + C_2_3*Omega*k2 + C_2_2_3*Omega*k1 + C_2_3_3*Omega*k1 + C_2_3*Omega*km2 + C_3_3*Omega*km2 - C_1_3*Omega*ks - k1*mu_2*mu_3 + C_2_2*Omega*k1*mu_3 + C_2_3*Omega*k1*mu_2 + C_2_3*Omega*k1*mu_3 + C_3_3*Omega*k1*mu_2)/Omega;
xdot(9) = -(k2*mu_3 - cE0*k2 - cE0*km2 - C_2_3*k1 + km2*mu_3 + 2*C_3_3*Omega*k2 + 2*C_2_3_3*Omega*k1 + 2*C_3_3*Omega*km2 - k1*mu_2*mu_3 + 2*C_2_3*Omega*k1*mu_3 + 2*C_3_3*Omega*k1*mu_2)/Omega;
xdot(10) = Omega*k0 - 3*C_1_1_1*kdm - Omega*kdm*mu_1 + 3*C_1_1*Omega^2*kdm;
xdot(11) = C_1_1_1*ks - 2*C_1_1_2*kdm - C_1_1_2*k1*mu_3 + C_1_2*Omega^2*kdm - C_1_1_3*Omega^3*km2 + C_1_1*C_2_3*Omega^3*k1 - C_1_1_3*Omega^3*k1*mu_2;
xdot(12) = -(C_1_1_2*k1*mu_3 + C_1_1_3*Omega^3*k2 - C_1_3*Omega^2*kdm + 2*C_1_1_3*Omega^3*kdm + C_1_1_3*Omega^3*km2 - C_1_1*C_2_3*Omega^3*k1 + C_1_1_3*Omega^3*k1*mu_2)/Omega^3;
xdot(13) = (2*C_1_1_2*ks + C_1_2_3*Omega^2*k1 - C_1_2_2*Omega^3*kdm - C_1_3*Omega^2*km2 - 2*C_1_2_3*Omega^3*km2 + C_1_1*Omega^2*ks + 2*C_1_2*C_2_3*Omega^3*k1 + C_1_2*Omega^2*k1*mu_3 + C_1_3*Omega^2*k1*mu_2 - 2*C_1_2_2*Omega^3*k1*mu_3 - 2*C_1_2_3*Omega^3*k1*mu_2)/Omega^3;
xdot(14) = -(C_1_3*km2 - C_1_2_3*k1 + C_1_2_3*Omega*k2 + C_1_2_3*Omega*kdm + C_1_2_3*Omega*km2 + C_1_3_3*Omega*km2 - C_1_1_3*Omega*ks - C_1_2*k1*mu_3 - C_1_3*k1*mu_2 - C_1_2*C_2_3*Omega*k1 - C_1_3*C_2_3*Omega*k1 + C_1_2_2*Omega*k1*mu_3 + C_1_2_3*Omega*k1*mu_2 + C_1_2_3*Omega*k1*mu_3 + C_1_3_3*Omega*k1*mu_2)/Omega;
xdot(15) = -(C_1_3*k2 - C_1_2_3*k1 + C_1_3*km2 + 2*C_1_3_3*Omega*k2 + C_1_3_3*Omega*kdm + 2*C_1_3_3*Omega*km2 - C_1_2*k1*mu_3 - C_1_3*k1*mu_2 - 2*C_1_3*C_2_3*Omega*k1 + 2*C_1_2_3*Omega*k1*mu_3 + 2*C_1_3_3*Omega*k1*mu_2)/Omega;
xdot(16) = (cE0*km2 - C_2_3*k1 - km2*mu_3 + ks*mu_1 + 3*C_2_2_3*Omega*k1 - 3*C_2_3*Omega*km2 + 3*C_1_2*Omega*ks - k1*mu_2*mu_3 - 3*C_2_2_3*Omega^2*km2 + 3*C_1_2_2*Omega^2*ks + 3*C_2_2*C_2_3*Omega^2*k1 - 3*C_2_2_2*Omega^2*k1*mu_3 - 3*C_2_2_3*Omega^2*k1*mu_2 + 3*C_2_2*Omega*k1*mu_3 + 3*C_2_3*Omega*k1*mu_2)/Omega^2;
xdot(17) = -(C_2_3*k1 - cE0*km2 + km2*mu_3 - 2*C_2_3^2*Omega^2*k1 - 2*C_2_2_3*Omega*k1 - C_2_3_3*Omega*k1 + 2*C_2_3*Omega*km2 + C_3_3*Omega*km2 - C_1_3*Omega*ks + k1*mu_2*mu_3 + C_2_2_3*Omega^2*k2 + C_2_2_3*Omega^2*km2 + 2*C_2_3_3*Omega^2*km2 - 2*C_1_2_3*Omega^2*ks - C_2_2*C_2_3*Omega^2*k1 + C_2_2_2*Omega^2*k1*mu_3 + C_2_2_3*Omega^2*k1*mu_2 + 2*C_2_2_3*Omega^2*k1*mu_3 + 2*C_2_3_3*Omega^2*k1*mu_2 - 2*C_2_2*Omega*k1*mu_3 - 2*C_2_3*Omega*k1*mu_2 - C_2_3*Omega*k1*mu_3 - C_3_3*Omega*k1*mu_2)/Omega^2;
xdot(18) = -(C_2_3*k1 - cE0*km2 + km2*mu_3 - 2*C_2_3^2*Omega^2*k1 + C_2_3*Omega*k2 - C_2_2_3*Omega*k1 - 2*C_2_3_3*Omega*k1 + C_2_3*Omega*km2 + 2*C_3_3*Omega*km2 + k1*mu_2*mu_3 + 2*C_2_3_3*Omega^2*k2 + 2*C_2_3_3*Omega^2*km2 + C_3_3_3*Omega^2*km2 - C_1_3_3*Omega^2*ks - C_2_3*C_3_3*Omega^2*k1 + 2*C_2_2_3*Omega^2*k1*mu_3 + 2*C_2_3_3*Omega^2*k1*mu_2 + C_2_3_3*Omega^2*k1*mu_3 + C_3_3_3*Omega^2*k1*mu_2 - C_2_2*Omega*k1*mu_3 - C_2_3*Omega*k1*mu_2 - 2*C_2_3*Omega*k1*mu_3 - 2*C_3_3*Omega*k1*mu_2)/Omega^2;
xdot(19) = -(C_2_3*k1 - cE0*k2 - cE0*km2 + k2*mu_3 + km2*mu_3 + 3*C_3_3*Omega*k2 - 3*C_2_3_3*Omega*k1 + 3*C_3_3*Omega*km2 + k1*mu_2*mu_3 + 3*C_3_3_3*Omega^2*k2 + 3*C_3_3_3*Omega^2*km2 - 3*C_2_3*C_3_3*Omega^2*k1 + 3*C_2_3_3*Omega^2*k1*mu_3 + 3*C_3_3_3*Omega^2*k1*mu_2 - 3*C_2_3*Omega*k1*mu_3 - 3*C_3_3*Omega*k1*mu_2)/Omega^2;
% INITIAL CONDITIONS

x0 = sym(zeros(size(x)));

x0(3) = cE0;

% OBSERVABLES

y = sym(zeros(9,1));

y(1) = mu_1;
y(2) = mu_2;
y(3) = mu_3;
y(4) = C_1_1;
y(5) = C_2_2;
y(6) = C_3_3;
y(7) = 3*C_1_1 + C_1_1_1;
y(8) = 3*C_2_2 + C_2_2_2;
y(9) = 3*C_3_3 + C_3_3_3;

% SYSTEM STRUCT

model.sym.x = x;
model.sym.u = u;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end