function [model] = model_1_EMRE_syms()

%% CVODES OPTIONS

% absolute tolerance
model.atol = 1e-8;
% relative tolerance
model.rtol = 1e-8;
% maximal number of steps
model.maxsteps = 1e4;

%% STATES

syms MRNA PROT ENZ COV11_LNA COV21_LNA COV22_LNA COV31_LNA COV32_LNA COV33_LNA MRNA_CORR_EMRE PROT_CORR_EMRE ENZ_CORR_EMRE

x = [MRNA,PROT,ENZ,COV11_LNA,COV21_LNA,COV22_LNA,COV31_LNA,COV32_LNA,COV33_LNA,MRNA_CORR_EMRE,PROT_CORR_EMRE,ENZ_CORR_EMRE];

%% PARAMETERS

syms k2 k0 kdm ks k1 km2 cE0 Omega

p = [k2,k0,kdm,ks,k1,km2,cE0,Omega];

%% INPUT 

u = sym.empty(0,0);

%% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

% RRE-MEAN
xdot(1) = k0 - kdm*MRNA;
xdot(2) = cE0*km2 - km2*ENZ + ks*MRNA - k1*PROT*ENZ;
xdot(3) = (cE0-ENZ)*k2 + (cE0-ENZ)*km2 - k1*PROT*ENZ;
% LNA-VAR
xdot(4) = (k0 + kdm*MRNA)/Omega - 2*kdm*COV11_LNA;
xdot(5) = ks*COV11_LNA - km2*COV31_LNA - kdm*COV21_LNA - k1*ENZ*COV21_LNA - k1*PROT*COV31_LNA;
xdot(6) = 2*ks*COV21_LNA - 2*km2*COV32_LNA + (cE0*km2 - km2*ENZ + ks*MRNA + k1*PROT*ENZ)/Omega - 2*k1*ENZ*COV22_LNA - 2*k1*PROT*COV32_LNA;
xdot(7) = - k2*COV31_LNA - kdm*COV31_LNA - km2*COV31_LNA - k1*ENZ*COV21_LNA - k1*PROT*COV31_LNA;
xdot(8) = ks*COV31_LNA - km2*COV32_LNA - km2*COV33_LNA - k2*COV32_LNA + (cE0*km2 - km2*ENZ + k1*PROT*ENZ)/Omega - k1*ENZ*COV22_LNA - k1*PROT*COV32_LNA - k1*PROT*COV33_LNA - k1*ENZ*COV32_LNA;
xdot(9) = (cE0*k2 + cE0*km2 - k2*ENZ - km2*ENZ + k1*PROT*ENZ)/Omega - 2*k2*COV33_LNA - 2*km2*COV33_LNA - 2*k1*PROT*COV33_LNA - 2*k1*ENZ*COV32_LNA;
% EMRE-MEAN
xdot(10) = -kdm*MRNA_CORR_EMRE;
xdot(11) = ks*MRNA_CORR_EMRE - km2*ENZ_CORR_EMRE - k1*COV32_LNA - k1*PROT*ENZ_CORR_EMRE - k1*ENZ*PROT_CORR_EMRE;
xdot(12) = - k1*COV32_LNA - k2*ENZ_CORR_EMRE - km2*ENZ_CORR_EMRE - k1*PROT*ENZ_CORR_EMRE - k1*ENZ*PROT_CORR_EMRE;

%% INITIAL CONDITIONS

x0 = sym(zeros(12,1));

x0(3) = cE0;

%% OBSERVABLES

y = sym(zeros(6,1));

y(1) = MRNA + MRNA_CORR_EMRE;
y(2) = PROT + PROT_CORR_EMRE;
y(3) = ENZ + ENZ_CORR_EMRE;
y(4) = COV11_LNA;
y(5) = COV22_LNA;
y(6) = COV33_LNA;

%% SYSTEM STRUCT

model.sym.x = x;
model.sym.u = u;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end