function [model] = model_1_IOS_syms()

%% CVODES OPTIONS

% absolute tolerance
model.atol = 1e-8;
% relative tolerance
model.rtol = 1e-8;
% maximal number of steps
model.maxsteps = 1e4;

%% STATES

syms MRNA PROT ENZ COV11_LNA COV21_LNA COV22_LNA COV31_LNA COV32_LNA COV33_LNA MRNA_CORR_EMRE PROT_CORR_EMRE ENZ_CORR_EMRE
syms SKEW111_IOS SKEW112_IOS SKEW113_IOS SKEW122_IOS SKEW123_IOS SKEW133_IOS SKEW222_IOS SKEW223_IOS SKEW233_IOS SKEW333_IOS
syms COV11_CORR_IOS COV21_CORR_IOS COV22_CORR_IOS COV31_CORR_IOS COV32_CORR_IOS COV33_CORR_IOS

x = [MRNA,PROT,ENZ,COV11_LNA,COV21_LNA,COV22_LNA,COV31_LNA,COV32_LNA,COV33_LNA,MRNA_CORR_EMRE,PROT_CORR_EMRE,ENZ_CORR_EMRE,...
    SKEW111_IOS,SKEW112_IOS,SKEW113_IOS,SKEW122_IOS,SKEW123_IOS,SKEW133_IOS,SKEW222_IOS,SKEW223_IOS,SKEW233_IOS,SKEW333_IOS,...
    COV11_CORR_IOS,COV21_CORR_IOS,COV22_CORR_IOS,COV31_CORR_IOS,COV32_CORR_IOS,COV33_CORR_IOS];

%% PARAMETERS

syms k2 k0 kdm ks k1 km2 cE0 Omega

p = [k2,k0,kdm,ks,k1,km2,cE0,Omega];
%p = [Omega,cE0,k0,k1,k2,kdm,km2,ks];

%% INPUT 

u = sym.empty(0,0);

%% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

% RRE-MEAN
xdot(1) = k0 - kdm*MRNA;
xdot(2) = cE0*km2 - km2*ENZ + ks*MRNA - k1*PROT*ENZ;
xdot(3) = (cE0-ENZ)*k2 + (cE0-ENZ)*km2 - k1*PROT*ENZ;
% LNA-VAR
xdot(4) = (k0 + kdm*MRNA)/Omega - 2*kdm*COV11_LNA;
xdot(5) = ks*COV11_LNA - km2*COV31_LNA - kdm*COV21_LNA - k1*ENZ*COV21_LNA - k1*PROT*COV31_LNA;
xdot(6) = 2*ks*COV21_LNA - 2*km2*COV32_LNA + (cE0*km2 - km2*ENZ + ks*MRNA + k1*PROT*ENZ)/Omega - 2*k1*ENZ*COV22_LNA - 2*k1*PROT*COV32_LNA;
xdot(7) = - k2*COV31_LNA - kdm*COV31_LNA - km2*COV31_LNA - k1*ENZ*COV21_LNA - k1*PROT*COV31_LNA;
xdot(8) = ks*COV31_LNA - km2*COV32_LNA - km2*COV33_LNA - k2*COV32_LNA + (cE0*km2 - km2*ENZ + k1*PROT*ENZ)/Omega - k1*ENZ*COV22_LNA - k1*PROT*COV32_LNA - k1*PROT*COV33_LNA - k1*ENZ*COV32_LNA;
xdot(9) = (cE0*k2 + cE0*km2 - k2*ENZ - km2*ENZ + k1*PROT*ENZ)/Omega - 2*k2*COV33_LNA - 2*km2*COV33_LNA - 2*k1*PROT*COV33_LNA - 2*k1*ENZ*COV32_LNA;
% EMRE-MEAN
xdot(10) = -kdm*MRNA_CORR_EMRE;
xdot(11) = ks*MRNA_CORR_EMRE - km2*ENZ_CORR_EMRE - k1*COV32_LNA - k1*PROT*ENZ_CORR_EMRE - k1*ENZ*PROT_CORR_EMRE;
xdot(12) = - k1*COV32_LNA - k2*ENZ_CORR_EMRE - km2*ENZ_CORR_EMRE - k1*PROT*ENZ_CORR_EMRE - k1*ENZ*PROT_CORR_EMRE;
% IOS-SKEW
xdot(13) = (k0 - kdm*MRNA)/Omega^2 - 3*kdm*SKEW111_IOS + (3*k0*MRNA_CORR_EMRE + 3*kdm*COV11_LNA + 3*kdm*MRNA*MRNA_CORR_EMRE)/Omega;
xdot(14) = ks*SKEW111_IOS - km2*SKEW123_IOS - 2*kdm*SKEW112_IOS + (k0*PROT_CORR_EMRE + kdm*COV21_LNA + kdm*MRNA*PROT_CORR_EMRE)/Omega - k1*COV11_LNA*COV32_LNA - 2*k1*COV21_LNA*COV31_LNA - k1*ENZ*SKEW112_IOS - k1*PROT*SKEW123_IOS;
xdot(15) = -(km2*COV31_LNA - ks*COV11_LNA + Omega*kdm*SKEW113_IOS + 2*Omega*km2*SKEW133_IOS - 2*Omega*ks*SKEW112_IOS - cE0*km2*MRNA_CORR_EMRE - k1*ENZ*COV21_LNA - k1*PROT*COV31_LNA + km2*ENZ*MRNA_CORR_EMRE - ks*MRNA*MRNA_CORR_EMRE + 4*Omega*k1*COV21_LNA*COV32_LNA + 2*Omega*k1*COV22_LNA*COV31_LNA + 2*Omega*k1*ENZ*SKEW113_IOS + 2*Omega*k1*PROT*SKEW133_IOS - k1*PROT*ENZ*MRNA_CORR_EMRE)/Omega;
xdot(16) = 3*ks*SKEW113_IOS - 3*km2*SKEW222_IOS + (3*ks*COV21_LNA - 3*km2*COV32_LNA + 3*cE0*km2*PROT_CORR_EMRE + 3*k1*ENZ*COV22_LNA + 3*k1*PROT*COV32_LNA - 3*km2*ENZ*PROT_CORR_EMRE + 3*ks*MRNA*PROT_CORR_EMRE + 3*k1*PROT*ENZ*PROT_CORR_EMRE)/Omega + (cE0*km2 - km2*ENZ + ks*MRNA - k1*PROT*ENZ)/Omega^2 - 9*k1*COV22_LNA*COV32_LNA - 3*k1*ENZ*SKEW122_IOS - 3*k1*PROT*SKEW222_IOS;
xdot(17) = (k0*ENZ_CORR_EMRE + kdm*COV31_LNA + kdm*MRNA*ENZ_CORR_EMRE)/Omega - 2*kdm*SKEW123_IOS - km2*SKEW123_IOS - k2*SKEW123_IOS - k1*COV11_LNA*COV32_LNA - 2*k1*COV21_LNA*COV31_LNA - k1*ENZ*SKEW112_IOS - k1*PROT*SKEW123_IOS;
xdot(18) = ks*SKEW123_IOS - kdm*SKEW133_IOS - km2*SKEW133_IOS - km2*SKEW223_IOS - k2*SKEW133_IOS - 2*k1*COV21_LNA*COV32_LNA - k1*COV22_LNA*COV31_LNA - k1*COV21_LNA*COV33_LNA - 2*k1*COV31_LNA*COV32_LNA - k1*ENZ*SKEW113_IOS - k1*PROT*SKEW133_IOS - k1*ENZ*SKEW133_IOS - k1*PROT*SKEW223_IOS - (km2*COV31_LNA)/Omega + (cE0*km2*MRNA_CORR_EMRE)/Omega + (k1*ENZ*COV21_LNA)/Omega + (k1*PROT*COV31_LNA)/Omega - (km2*ENZ*MRNA_CORR_EMRE)/Omega + (k1*PROT*ENZ*MRNA_CORR_EMRE)/Omega;
xdot(19) = -(km2*ENZ - cE0*km2 + 4*Omega^2*k1*COV32_LNA^2 + 2*Omega*km2*COV32_LNA + Omega*km2*COV33_LNA - Omega*ks*COV31_LNA + k1*PROT*ENZ + Omega^2*k2*SKEW222_IOS + Omega^2*km2*SKEW222_IOS + 2*Omega^2*km2*SKEW233_IOS - 2*Omega^2*ks*SKEW133_IOS - 2*Omega*k1*ENZ*COV22_LNA - 2*Omega*k1*PROT*COV32_LNA - Omega*k1*PROT*COV33_LNA - Omega*k1*ENZ*COV32_LNA + 2*Omega*km2*ENZ*PROT_CORR_EMRE + Omega*km2*ENZ*ENZ_CORR_EMRE - Omega*ks*MRNA*ENZ_CORR_EMRE + 3*Omega^2*k1*COV22_LNA*COV32_LNA + 2*Omega^2*k1*COV22_LNA*COV33_LNA + Omega^2*k1*ENZ*SKEW122_IOS + Omega^2*k1*PROT*SKEW222_IOS + 2*Omega^2*k1*ENZ*SKEW222_IOS + 2*Omega^2*k1*PROT*SKEW233_IOS - 2*Omega*cE0*km2*PROT_CORR_EMRE - Omega*cE0*km2*ENZ_CORR_EMRE - 2*Omega*k1*PROT*ENZ*PROT_CORR_EMRE - Omega*k1*PROT*ENZ*ENZ_CORR_EMRE)/Omega^2;
xdot(20) = -(k2*COV31_LNA + km2*COV31_LNA + 2*Omega*k2*SKEW223_IOS + Omega*kdm*SKEW223_IOS + 2*Omega*km2*SKEW223_IOS - cE0*k2*MRNA_CORR_EMRE - cE0*km2*MRNA_CORR_EMRE - k1*ENZ*COV21_LNA - k1*PROT*COV31_LNA + k2*ENZ*MRNA_CORR_EMRE + km2*ENZ*MRNA_CORR_EMRE + 2*Omega*k1*COV21_LNA*COV33_LNA + 4*Omega*k1*COV31_LNA*COV32_LNA + 2*Omega*k1*ENZ*SKEW133_IOS + 2*Omega*k1*PROT*SKEW223_IOS - k1*PROT*ENZ*MRNA_CORR_EMRE)/Omega;
xdot(21) = -(km2*ENZ - cE0*km2 + 4*Omega^2*k1*COV32_LNA^2 + Omega*k2*COV32_LNA + Omega*km2*COV32_LNA + 2*Omega*km2*COV33_LNA + k1*PROT*ENZ + 2*Omega^2*k2*SKEW233_IOS + 2*Omega^2*km2*SKEW233_IOS + Omega^2*km2*SKEW333_IOS - Omega^2*ks*SKEW223_IOS - Omega*k1*ENZ*COV22_LNA - Omega*k1*PROT*COV32_LNA - 2*Omega*k1*PROT*COV33_LNA - 2*Omega*k1*ENZ*COV32_LNA + Omega*k2*ENZ*PROT_CORR_EMRE + Omega*km2*ENZ*PROT_CORR_EMRE + 2*Omega*km2*ENZ*ENZ_CORR_EMRE + 2*Omega^2*k1*COV22_LNA*COV33_LNA + 3*Omega^2*k1*COV32_LNA*COV33_LNA + 2*Omega^2*k1*ENZ*SKEW222_IOS + 2*Omega^2*k1*PROT*SKEW233_IOS + Omega^2*k1*PROT*SKEW333_IOS + Omega^2*k1*ENZ*SKEW233_IOS - Omega*cE0*k2*PROT_CORR_EMRE - Omega*cE0*km2*PROT_CORR_EMRE - 2*Omega*cE0*km2*ENZ_CORR_EMRE - Omega*k1*PROT*ENZ*PROT_CORR_EMRE - 2*Omega*k1*PROT*ENZ*ENZ_CORR_EMRE)/Omega^2;
xdot(22) = -(k2*ENZ - cE0*km2 - cE0*k2 + km2*ENZ + 3*Omega*k2*COV33_LNA + 3*Omega*km2*COV33_LNA + k1*PROT*ENZ + 3*Omega^2*k2*SKEW333_IOS + 3*Omega^2*km2*SKEW333_IOS - 3*Omega*k1*PROT*COV33_LNA - 3*Omega*k1*ENZ*COV32_LNA + 3*Omega*k2*ENZ*ENZ_CORR_EMRE + 3*Omega*km2*ENZ*ENZ_CORR_EMRE + 9*Omega^2*k1*COV32_LNA*COV33_LNA + 3*Omega^2*k1*PROT*SKEW333_IOS + 3*Omega^2*k1*ENZ*SKEW233_IOS - 3*Omega*cE0*k2*ENZ_CORR_EMRE - 3*Omega*cE0*km2*ENZ_CORR_EMRE - 3*Omega*k1*PROT*ENZ*ENZ_CORR_EMRE)/Omega^2;
% IOS-VAR
xdot(23) = (kdm*(MRNA_CORR_EMRE - 2*Omega*COV11_CORR_IOS))/Omega;
xdot(24) = ks*COV11_CORR_IOS - kdm*COV21_CORR_IOS - km2*COV31_CORR_IOS - k1*SKEW133_IOS - k1*ENZ*COV21_CORR_IOS - k1*PROT*COV31_CORR_IOS;
xdot(25) = 2*ks*COV21_CORR_IOS - 2*km2*COV32_CORR_IOS - 2*k1*SKEW222_IOS + (k1*COV32_LNA - km2*ENZ_CORR_EMRE + ks*MRNA_CORR_EMRE + k1*PROT*ENZ_CORR_EMRE + k1*ENZ*PROT_CORR_EMRE)/Omega - 2*k1*ENZ*COV22_CORR_IOS - 2*k1*PROT*COV32_CORR_IOS;
xdot(26) = - k1*SKEW133_IOS - k2*COV31_CORR_IOS - kdm*COV31_CORR_IOS - km2*COV31_CORR_IOS - k1*ENZ*COV21_CORR_IOS - k1*PROT*COV31_CORR_IOS;
xdot(27) = ks*COV31_CORR_IOS - k1*SKEW233_IOS - k2*COV32_CORR_IOS - km2*COV32_CORR_IOS - km2*COV33_CORR_IOS - k1*SKEW222_IOS + (k1*COV32_LNA - km2*ENZ_CORR_EMRE + k1*PROT*ENZ_CORR_EMRE + k1*ENZ*PROT_CORR_EMRE)/Omega - k1*ENZ*COV22_CORR_IOS - k1*PROT*COV32_CORR_IOS - k1*PROT*COV33_CORR_IOS - k1*ENZ*COV32_CORR_IOS;
xdot(28) = (k1*COV32_LNA - k2*ENZ_CORR_EMRE - km2*ENZ_CORR_EMRE + k1*PROT*ENZ_CORR_EMRE + k1*ENZ*PROT_CORR_EMRE)/Omega - 2*k2*COV33_CORR_IOS - 2*km2*COV33_CORR_IOS - 2*k1*SKEW233_IOS - 2*k1*PROT*COV33_CORR_IOS - 2*k1*ENZ*COV32_CORR_IOS;

%% INITIAL CONDITIONS

x0 = sym(zeros(28,1));

x0(3) = cE0;

%% OBSERVABLES

y = sym(zeros(6,1));

y(1) = MRNA + MRNA_CORR_EMRE;
y(2) = PROT + PROT_CORR_EMRE;
y(3) = ENZ + ENZ_CORR_EMRE;
y(4) = COV11_LNA + COV11_CORR_IOS - MRNA_CORR_EMRE^2;
y(5) = COV22_LNA + COV22_CORR_IOS - PROT_CORR_EMRE^2;
y(6) = COV33_LNA + COV33_CORR_IOS - ENZ_CORR_EMRE^2;

%% SYSTEM STRUCT

model.sym.x = x;
model.sym.u = u;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end