function [model] = model_1_RRE_syms()

%% CVODES OPTIONS

% absolute tolerance
model.atol = 1e-8;
% relative tolerance
model.rtol = 1e-8;
% maximal number of steps
model.maxsteps = 1e4;

%% STATES

syms MRNA PROT ENZ

x = [MRNA,PROT,ENZ];

%% PARAMETERS

syms k2 k0 ksm ks k1 km2 cE0 Omega

p = [k2,k0,ksm,ks,k1,km2,cE0,Omega];

%% CONSTANTS

k = sym.empty(0,0);

%% INPUT 

u = sym.empty(0,0);

%% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

% RRE-MEAN
xdot(1) = k0 - ksm*MRNA;
xdot(2) = cE0*km2 - km2*ENZ + ks*MRNA - k1*PROT*ENZ;
xdot(3) = (cE0-ENZ)*k2 + (cE0-ENZ)*km2 - k1*PROT*ENZ;

%% INITIAL CONDITIONS

x0 = sym(zeros(size(x)));

x0(3) = cE0;

%% OBSERVABLES

y = sym(zeros(3,1));

y(1) = MRNA;
y(2) = PROT;
y(3) = ENZ;


%% SYSTEM STRUCT

model.sym.x = x;
model.sym.u = u;
model.sym.k = k;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end