function [model] = model_trimerization_IOS_syms()

%% CVODES OPTIONS

% absolute tolerance
model.atol = 1e-8;
% relative tolerance
model.rtol = 1e-8;
% maximal number of steps
model.maxsteps = 1e4;

%% STATES

syms X1 X2 X3 COV11_LNA COV21_LNA COV22_LNA COV31_LNA COV32_LNA COV33_LNA X1_CORR_EMRE X2_CORR_EMRE X3_CORR_EMRE
syms SKEW111_IOS SKEW112_IOS SKEW113_IOS SKEW122_IOS SKEW123_IOS SKEW133_IOS SKEW222_IOS SKEW223_IOS SKEW233_IOS SKEW333_IOS
syms COV11_CORR_IOS COV21_CORR_IOS COV22_CORR_IOS COV31_CORR_IOS COV32_CORR_IOS COV33_CORR_IOS

x = [X1,X2,X3,COV11_LNA,COV21_LNA,COV22_LNA,COV31_LNA,COV32_LNA,COV33_LNA,X1_CORR_EMRE,X2_CORR_EMRE,X3_CORR_EMRE,...
    SKEW111_IOS,SKEW112_IOS,SKEW113_IOS,SKEW122_IOS,SKEW123_IOS,SKEW133_IOS,SKEW222_IOS,SKEW223_IOS,SKEW233_IOS,SKEW333_IOS,...
    COV11_CORR_IOS,COV21_CORR_IOS,COV22_CORR_IOS,COV31_CORR_IOS,COV32_CORR_IOS,COV33_CORR_IOS];

%% PARAMETERS

syms k0 k1 k1m k2 k3 k4 Omega

p = [k0,k1,k1m,k2,k3,k4,Omega];

%% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

% RRE-MEAN
xdot(1)=-X1*k2+(30.0)*k0-(2.0)*k1*X1^2-X1*k1m*X2;
xdot(2)=k1*X1^2-k3*X2-X1*k1m*X2;
xdot(3)=-X3*k4+X1*k1m*X2;
% LNA-VAR
xdot(4)=(X1*k2+(900.0)*k0+(4.0)*k1*X1^2-(8.0)*k1*COV11_LNA*X1*Omega-(2.0)*COV11_LNA*Omega*k2-(2.0)*COV11_LNA*k1m*Omega*X2+X1*k1m*X2-(2.0)*X1*k1m*COV21_LNA*Omega)*Omega^(-1);
xdot(5)=(-(2.0)*k1*X1^2+(2.0)*k1*COV11_LNA*X1*Omega-COV22_LNA*X1*k1m*Omega-COV11_LNA*k1m*Omega*X2-(4.0)*k1*X1*COV21_LNA*Omega+X1*k1m*X2-k3*COV21_LNA*Omega-X1*k1m*COV21_LNA*Omega-COV21_LNA*Omega*k2-k1m*COV21_LNA*Omega*X2)*Omega^(-1);
xdot(6)=(k1*X1^2-(2.0)*COV22_LNA*X1*k1m*Omega+(4.0)*k1*X1*COV21_LNA*Omega+k3*X2+X1*k1m*X2-(2.0)*COV22_LNA*k3*Omega-(2.0)*k1m*COV21_LNA*Omega*X2)*Omega^(-1);
xdot(7)=(-COV31_LNA*k4*Omega-COV31_LNA*k1m*Omega*X2-X1*k1m*COV32_LNA*Omega+COV11_LNA*k1m*Omega*X2-X1*k1m*X2+X1*k1m*COV21_LNA*Omega-COV31_LNA*Omega*k2-(4.0)*k1*COV31_LNA*X1*Omega)*Omega^(-1);
xdot(8)=(-k3*COV32_LNA*Omega+COV22_LNA*X1*k1m*Omega-COV31_LNA*k1m*Omega*X2-X1*k1m*COV32_LNA*Omega-X1*k1m*X2-k4*COV32_LNA*Omega+k1m*COV21_LNA*Omega*X2+(2.0)*k1*COV31_LNA*X1*Omega)*Omega^(-1);
xdot(9)=(-(2.0)*COV33_LNA*k4*Omega+2*COV31_LNA*k1m*Omega*X2+X3*k4+2*X1*k1m*COV32_LNA*Omega+X1*k1m*X2)*Omega^(-1);
% EMRE-MEAN
xdot(10)=(-X1_CORR_EMRE*k1m*Omega*X2-X1*k1m*X2_CORR_EMRE*Omega-X1_CORR_EMRE*Omega*k2+(2.0)*k1*X1-(4.0)*k1*X1_CORR_EMRE*X1*Omega-k1m*COV21_LNA*Omega-(2.0)*k1*COV11_LNA*Omega)*Omega^(-1);
xdot(11)=(-X1_CORR_EMRE*k1m*Omega*X2-k3*X2_CORR_EMRE*Omega-X1*k1m*X2_CORR_EMRE*Omega-k1*X1+(2.0)*k1*X1_CORR_EMRE*X1*Omega-k1m*COV21_LNA*Omega+k1*COV11_LNA*Omega)*Omega^(-1);
xdot(12)=k1m*COV21_LNA-X3_CORR_EMRE*k4+X1_CORR_EMRE*k1m*X2+X1*k1m*X2_CORR_EMRE;
% IOS-SKEW
xdot(13)=Omega^(-2)*(-X1*k2+(27000.0)*k0-(3.0)*SKEW111_IOS*k1m*Omega^2*X2-(8.0)*k1*X1^2+3*X1_CORR_EMRE*X1*Omega*k2-(9.0)*COV11_LNA*k1m*COV21_LNA*Omega^2+(30.0)*k1*COV11_LNA*X1*Omega+3*COV11_LNA*Omega*k2-(18.0)*k1*COV11_LNA^2*Omega^2+3*COV11_LNA*k1m*Omega*X2-(12.0)*k1*SKEW111_IOS*X1*Omega^2+(12.0)*k1*X1_CORR_EMRE*X1^2*Omega-X1*k1m*X2+3*X1*k1m*COV21_LNA*Omega-(3.0)*X1*k1m*SKEW112_IOS*Omega^2+(2700.0)*k0*X1_CORR_EMRE*Omega+3*X1_CORR_EMRE*X1*k1m*Omega*X2-(3.0)*SKEW111_IOS*Omega^2*k2);
xdot(14)=(-(12.0)*k1*COV11_LNA*COV21_LNA*Omega^2-SKEW111_IOS*k1m*Omega^2*X2+(4.0)*k1*X1^2-(4.0)*k1m*COV21_LNA^2*Omega^2+(900.0)*k0*X2_CORR_EMRE*Omega-(3.0)*COV11_LNA*k1m*COV21_LNA*Omega^2-(9.0)*k1*COV11_LNA*X1*Omega+COV22_LNA*X1*k1m*Omega+(3.0)*k1*COV11_LNA^2*Omega^2-(2.0)*SKEW112_IOS*Omega^2*k2-(2.0)*X1*k1m*Omega^2*SKEW113_IOS-(2.0)*k1m*SKEW112_IOS*Omega^2*X2+2*COV11_LNA*k1m*Omega*X2+(2.0)*k1*SKEW111_IOS*X1*Omega^2+(12.0)*k1*X1*COV21_LNA*Omega-(4.0)*k1*X1_CORR_EMRE*X1^2*Omega-X1*k1m*X2+X1*k1m*X2_CORR_EMRE*Omega*X2+2*X1*k1m*COV21_LNA*Omega+COV21_LNA*Omega*k2-k3*SKEW112_IOS*Omega^2+k1m*COV21_LNA*Omega*X2-(2.0)*COV22_LNA*COV11_LNA*k1m*Omega^2-(8.0)*k1*X1*SKEW112_IOS*Omega^2+X1*X2_CORR_EMRE*Omega*k2+(4.0)*k1*X1^2*X2_CORR_EMRE*Omega-X1*k1m*SKEW112_IOS*Omega^2+2*X1_CORR_EMRE*X1*k1m*Omega*X2)*Omega^(-2);
xdot(15)=(-(3.0)*COV22_LNA*k1m*COV21_LNA*Omega^2+(6.0)*k1*COV11_LNA*COV21_LNA*Omega^2-(2.0)*k1*X1^2-(4.0)*k1m*COV21_LNA^2*Omega^2-(2.0)*k3*Omega^2*SKEW113_IOS-(2.0)*COV22_LNA*k1*COV11_LNA*Omega^2+k3*X1_CORR_EMRE*Omega*X2+(2.0)*k1*COV11_LNA*X1*Omega+2*COV22_LNA*X1*k1m*Omega-(4.0)*k1*X1*Omega^2*SKEW113_IOS-k1m*Omega^2*X2*SKEW113_IOS-(2.0)*X1*k1m*Omega^2*SKEW113_IOS-(2.0)*k1m*SKEW112_IOS*Omega^2*X2-Omega^2*k2*SKEW113_IOS+COV11_LNA*k1m*Omega*X2-(10.0)*k1*X1*COV21_LNA*Omega+k1*X1_CORR_EMRE*X1^2*Omega-(4.0)*k1*COV21_LNA^2*Omega^2-X1*k1m*X2+2*X1*k1m*X2_CORR_EMRE*Omega*X2+k3*COV21_LNA*Omega+X1*k1m*COV21_LNA*Omega-SKEW122_IOS*X1*k1m*Omega^2+(2.0)*COV22_LNA*k1*X1*Omega+2*k1m*COV21_LNA*Omega*X2-(2.0)*COV22_LNA*COV11_LNA*k1m*Omega^2+(4.0)*k1*X1*SKEW112_IOS*Omega^2-(4.0)*k1*X1^2*X2_CORR_EMRE*Omega+X1_CORR_EMRE*X1*k1m*Omega*X2)*Omega^(-2);
xdot(16)=(-(9.0)*COV22_LNA*k1m*COV21_LNA*Omega^2+k1*X1^2+(3.0)*COV22_LNA*k1*COV11_LNA*Omega^2-(3.0)*k3*SKEW122_IOS*Omega^2+3*COV22_LNA*X1*k1m*Omega+(6.0)*k1*X1*Omega^2*SKEW113_IOS-(3.0)*k1m*Omega^2*X2*SKEW113_IOS+(6.0)*k1*X1*COV21_LNA*Omega-k3*X2+(6.0)*k1*COV21_LNA^2*Omega^2-X1*k1m*X2+3*X1*k1m*X2_CORR_EMRE*Omega*X2-(3.0)*SKEW122_IOS*X1*k1m*Omega^2+3*k3*X2_CORR_EMRE*Omega*X2+3*COV22_LNA*k3*Omega-(3.0)*COV22_LNA*k1*X1*Omega+3*k1m*COV21_LNA*Omega*X2+3*k1*X1^2*X2_CORR_EMRE*Omega)*Omega^(-2);
xdot(17)=(SKEW111_IOS*k1m*Omega^2*X2+(900.0)*k0*X3_CORR_EMRE*Omega-(4.0)*COV31_LNA*k1m*COV21_LNA*Omega^2+X3_CORR_EMRE*X1*k1m*Omega*X2+3*COV11_LNA*k1m*COV21_LNA*Omega^2-(2.0)*X1*k1m*Omega^2*SKEW133_IOS-(2.0)*SKEW123_IOS*k1m*Omega^2*X2-(8.0)*k1*SKEW123_IOS*X1*Omega^2-(12.0)*k1*COV31_LNA*COV11_LNA*Omega^2+COV31_LNA*k1m*Omega*X2+X1*k1m*COV32_LNA*Omega-(2.0)*COV11_LNA*k1m*Omega*X2+(4.0)*X3_CORR_EMRE*k1*X1^2*Omega+X1*k1m*X2-(2.0)*X1*k1m*COV21_LNA*Omega+COV31_LNA*Omega*k2-(2.0)*SKEW123_IOS*Omega^2*k2+(12.0)*k1*COV31_LNA*X1*Omega+X1*k1m*SKEW112_IOS*Omega^2-k4*SKEW123_IOS*Omega^2-(2.0)*COV11_LNA*k1m*COV32_LNA*Omega^2-(2.0)*X1_CORR_EMRE*X1*k1m*Omega*X2+X3_CORR_EMRE*X1*Omega*k2)*Omega^(-2);
xdot(18)=(-(2.0)*COV31_LNA*k1m*COV21_LNA*Omega^2+2*k1m*COV21_LNA^2*Omega^2-k1m*Omega^2*SKEW133_IOS*X2-Omega^2*SKEW133_IOS*k2+X3_CORR_EMRE*X1*k1m*Omega*X2-(2.0)*k1m*COV32_LNA*COV21_LNA*Omega^2-COV22_LNA*COV31_LNA*k1m*Omega^2-X1*k1m*Omega^2*SKEW133_IOS-SKEW123_IOS*k1m*Omega^2*X2+(2.0)*k1*SKEW123_IOS*X1*Omega^2+(3.0)*k1*COV31_LNA*COV11_LNA*Omega^2+(2.0)*k1*X1*COV32_LNA*Omega-COV22_LNA*X1*k1m*Omega+COV31_LNA*k1m*Omega*X2+X1*k1m*Omega^2*SKEW113_IOS+k1m*SKEW112_IOS*Omega^2*X2+X1*k1m*COV32_LNA*Omega-k3*Omega^2*SKEW133_IOS-COV11_LNA*k1m*Omega*X2-(4.0)*k1*X1*Omega^2*SKEW133_IOS-(2.0)*X3_CORR_EMRE*k1*X1^2*Omega+X1*k1m*X2-X1*k1m*X2_CORR_EMRE*Omega*X2-k4*Omega^2*SKEW133_IOS-(4.0)*k1*COV31_LNA*COV21_LNA*Omega^2-X1*k1m*COV21_LNA*Omega-k1m*COV21_LNA*Omega*X2+COV22_LNA*COV11_LNA*k1m*Omega^2-(2.0)*k1*COV11_LNA*COV32_LNA*Omega^2-(5.0)*k1*COV31_LNA*X1*Omega-SKEW222_IOS*X1*k1m*Omega^2-COV11_LNA*k1m*COV32_LNA*Omega^2-X1_CORR_EMRE*X1*k1m*Omega*X2)*Omega^(-2);
xdot(19)=(3*COV22_LNA*k1m*COV21_LNA*Omega^2-(2.0)*k1m*Omega^2*SKEW133_IOS*X2+X3_CORR_EMRE*X1*k1m*Omega*X2-(4.0)*k1m*COV32_LNA*COV21_LNA*Omega^2+k3*COV32_LNA*Omega-(2.0)*COV22_LNA*COV31_LNA*k1m*Omega^2-(2.0)*k1*X1*COV32_LNA*Omega-(2.0)*COV22_LNA*X1*k1m*Omega+COV31_LNA*k1m*Omega*X2+k1m*Omega^2*X2*SKEW113_IOS+X1*k1m*COV32_LNA*Omega+(4.0)*k1*X1*Omega^2*SKEW133_IOS+X3_CORR_EMRE*k1*X1^2*Omega+X1*k1m*X2-(2.0)*X1*k1m*X2_CORR_EMRE*Omega*X2+(4.0)*k1*COV31_LNA*COV21_LNA*Omega^2-SKEW222_IOS*k4*Omega^2+SKEW122_IOS*X1*k1m*Omega^2-(2.0)*k1m*COV21_LNA*Omega*X2-(2.0)*SKEW222_IOS*k3*Omega^2+(2.0)*k1*COV11_LNA*COV32_LNA*Omega^2+(2.0)*k1*COV31_LNA*X1*Omega-(2.0)*SKEW222_IOS*X1*k1m*Omega^2+X3_CORR_EMRE*k3*Omega*X2)*Omega^(-2);
xdot(20)=(-X1*k1m*SKEW233_IOS*Omega^2-(4.0)*k1*COV31_LNA^2*Omega^2+4*COV31_LNA*k1m*COV21_LNA*Omega^2-(2.0)*SKEW223_IOS*k4*Omega^2-(2.0)*X3_CORR_EMRE*X1*k1m*Omega*X2+COV31_LNA*k4*Omega-(2.0)*COV33_LNA*k1*COV11_LNA*Omega^2+X3*X1_CORR_EMRE*k4*Omega+2*X1*k1m*Omega^2*SKEW133_IOS-SKEW223_IOS*Omega^2*k2+2*SKEW123_IOS*k1m*Omega^2*X2-(2.0)*COV31_LNA*k1m*Omega*X2-(2.0)*X1*k1m*COV32_LNA*Omega+COV11_LNA*k1m*Omega*X2-SKEW223_IOS*k1m*Omega^2*X2-COV33_LNA*k1m*COV21_LNA*Omega^2-X1*k1m*X2+(2.0)*COV33_LNA*k1*X1*Omega+X1*k1m*COV21_LNA*Omega-(2.0)*COV31_LNA*k1m*COV32_LNA*Omega^2-(4.0)*k1*SKEW223_IOS*X1*Omega^2+2*COV11_LNA*k1m*COV32_LNA*Omega^2+X1_CORR_EMRE*X1*k1m*Omega*X2)*Omega^(-2);
xdot(21)=(-X1*k1m*SKEW233_IOS*Omega^2+2*k1*COV31_LNA^2*Omega^2+2*k1m*Omega^2*SKEW133_IOS*X2-k3*SKEW233_IOS*Omega^2+X3*k4*X2_CORR_EMRE*Omega-(2.0)*X3_CORR_EMRE*X1*k1m*Omega*X2+4*k1m*COV32_LNA*COV21_LNA*Omega^2+COV33_LNA*k1*COV11_LNA*Omega^2+2*COV22_LNA*COV31_LNA*k1m*Omega^2+COV22_LNA*X1*k1m*Omega-(2.0)*COV31_LNA*k1m*Omega*X2-(2.0)*X1*k1m*COV32_LNA*Omega-SKEW223_IOS*k1m*Omega^2*X2-COV33_LNA*k1m*COV21_LNA*Omega^2-X1*k1m*X2+X1*k1m*X2_CORR_EMRE*Omega*X2-COV33_LNA*k1*X1*Omega+k4*COV32_LNA*Omega-(2.0)*COV31_LNA*k1m*COV32_LNA*Omega^2+(2.0)*k1*SKEW223_IOS*X1*Omega^2+k1m*COV21_LNA*Omega*X2-(2.0)*k4*SKEW233_IOS*Omega^2+2*SKEW222_IOS*X1*k1m*Omega^2)*Omega^(-2);
xdot(22)=(3*COV33_LNA*k4*Omega+3*X1*k1m*SKEW233_IOS*Omega^2+3*X3_CORR_EMRE*X1*k1m*Omega*X2-(3.0)*SKEW333_IOS*k4*Omega^2+3*COV31_LNA*k1m*Omega*X2-X3*k4+3*X1*k1m*COV32_LNA*Omega+3*SKEW223_IOS*k1m*Omega^2*X2+3*X3_CORR_EMRE*X3*k4*Omega+3*COV33_LNA*k1m*COV21_LNA*Omega^2+X1*k1m*X2+6*COV31_LNA*k1m*COV32_LNA*Omega^2)*Omega^(-2);
% IOS-VAR
xdot(23)=(X1_CORR_EMRE*k1m*Omega*X2+X1*k1m*X2_CORR_EMRE*Omega-(8.0)*k1*COV11_CORR_IOS*X1*Omega^2-(2.0)*X1*k1m*COV21_CORR_IOS*Omega^2+X1_CORR_EMRE*Omega*k2-(4.0)*k1*X1+(12.0)*k1*X1_CORR_EMRE*X1*Omega+k1m*COV21_LNA*Omega-(4.0)*k1*SKEW111_IOS*Omega^2-(2.0)*COV11_CORR_IOS*Omega^2*k2-(2.0)*COV11_CORR_IOS*k1m*Omega^2*X2+(8.0)*k1*COV11_LNA*Omega-(2.0)*k1m*SKEW112_IOS*Omega^2)*Omega^(-2);
xdot(24)=(X1_CORR_EMRE*k1m*Omega*X2+(2.0)*k1*COV21_LNA*Omega+(2.0)*k1*X1*X2_CORR_EMRE*Omega+X1*k1m*X2_CORR_EMRE*Omega-COV21_CORR_IOS*Omega^2*k2+(2.0)*k1*COV11_CORR_IOS*X1*Omega^2-k1m*COV21_CORR_IOS*Omega^2*X2-COV22_CORR_IOS*X1*k1m*Omega^2-X1*k1m*COV21_CORR_IOS*Omega^2-k1m*Omega^2*SKEW113_IOS-(2.0)*k1*SKEW112_IOS*Omega^2+(2.0)*k1*X1-k3*COV21_CORR_IOS*Omega^2-(4.0)*k1*X1*COV21_CORR_IOS*Omega^2-(5.0)*k1*X1_CORR_EMRE*X1*Omega+k1m*COV21_LNA*Omega+k1*SKEW111_IOS*Omega^2-COV11_CORR_IOS*k1m*Omega^2*X2-(3.0)*k1*COV11_LNA*Omega-k1m*SKEW112_IOS*Omega^2)*Omega^(-2);
xdot(25)=(X1_CORR_EMRE*k1m*Omega*X2-(2.0)*k1*COV21_LNA*Omega+k3*X2_CORR_EMRE*Omega-(2.0)*k1*X1*X2_CORR_EMRE*Omega+X1*k1m*X2_CORR_EMRE*Omega-(2.0)*k1m*COV21_CORR_IOS*Omega^2*X2-(2.0)*COV22_CORR_IOS*X1*k1m*Omega^2-(2.0)*k1m*Omega^2*SKEW113_IOS+(2.0)*k1*SKEW112_IOS*Omega^2-k1*X1+(4.0)*k1*X1*COV21_CORR_IOS*Omega^2+(2.0)*k1*X1_CORR_EMRE*X1*Omega+k1m*COV21_LNA*Omega-(2.0)*COV22_CORR_IOS*k3*Omega^2+k1*COV11_LNA*Omega)*Omega^(-2);
xdot(26)=(-COV31_CORR_IOS*k4*Omega-COV31_CORR_IOS*k1m*Omega*X2+(2.0)*k1*COV31_LNA+X1*k1m*COV21_CORR_IOS*Omega-k1m*COV21_LNA+COV11_CORR_IOS*k1m*Omega*X2-X1_CORR_EMRE*k1m*X2-k1m*Omega*SKEW133_IOS+k1m*SKEW112_IOS*Omega+(2.0)*X3_CORR_EMRE*k1*X1-(4.0)*k1*COV31_CORR_IOS*X1*Omega-X1*k1m*X2_CORR_EMRE-X1*k1m*COV32_CORR_IOS*Omega-COV31_CORR_IOS*Omega*k2-(2.0)*k1*SKEW123_IOS*Omega)*Omega^(-1);
xdot(27)=Omega^(-1)*(-COV31_CORR_IOS*k1m*Omega*X2-k1*COV31_LNA-k1m*COV21_LNA-k4*COV32_CORR_IOS*Omega+COV22_CORR_IOS*X1*k1m*Omega-X1_CORR_EMRE*k1m*X2-k1m*Omega*SKEW133_IOS+k1m*Omega*SKEW113_IOS-k3*COV32_CORR_IOS*Omega-X3_CORR_EMRE*k1*X1+k1m*COV21_CORR_IOS*Omega*X2+(2.0)*k1*COV31_CORR_IOS*X1*Omega-X1*k1m*X2_CORR_EMRE-X1*k1m*COV32_CORR_IOS*Omega+k1*SKEW123_IOS*Omega);
xdot(28)=Omega^(-1)*(-(2.0)*COV33_CORR_IOS*k4*Omega+2*COV31_CORR_IOS*k1m*Omega*X2+k1m*COV21_LNA+X3_CORR_EMRE*k4+X1_CORR_EMRE*k1m*X2+2*k1m*Omega*SKEW133_IOS+X1*k1m*X2_CORR_EMRE+2*X1*k1m*COV32_CORR_IOS*Omega);

%% INITIAL CONDITIONS

x0 = sym(zeros(28,1));

%% OBSERVABLES

y = sym(zeros(6,1));

y(1) = X1 + X1_CORR_EMRE;
y(2) = X2 + X2_CORR_EMRE;
y(3) = X3 + X3_CORR_EMRE;
y(4) = COV11_LNA + COV11_CORR_IOS;
y(5) = COV22_LNA + COV22_CORR_IOS;
y(6) = COV33_LNA + COV33_CORR_IOS;

%% SYSTEM STRUCT

model.sym.x = x;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end