function [model] = model_trimerization_IOS_syms()

%% CVODES OPTIONS

% absolute tolerance
model.atol = 1e-8;
% relative tolerance
model.rtol = 1e-8;
% maximal number of steps
model.maxsteps = 1e4;

%% STATES

syms X1 X2 X3 COV11_LNA COV21_LNA COV22_LNA COV31_LNA COV32_LNA COV33_LNA

x = [X1,X2,X3,COV11_LNA,COV21_LNA,COV22_LNA,COV31_LNA,COV32_LNA,COV33_LNA];

%% PARAMETERS

syms k0 k1 k1m k2 k3 k4 Omega

p = [k0,k1,k1m,k2,k3,k4,Omega];

%% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

% RRE-MEAN
xdot(1)=-X1*k2+(30.0)*k0-(2.0)*k1*X1^2-X1*k1m*X2;
xdot(2)=k1*X1^2-k3*X2-X1*k1m*X2;
xdot(3)=-X3*k4+X1*k1m*X2;
% LNA-VAR
xdot(4)=(X1*k2+(900.0)*k0+(4.0)*k1*X1^2-(8.0)*k1*COV11_LNA*X1*Omega-(2.0)*COV11_LNA*Omega*k2-(2.0)*COV11_LNA*k1m*Omega*X2+X1*k1m*X2-(2.0)*X1*k1m*COV21_LNA*Omega)*Omega^(-1);
xdot(5)=(-(2.0)*k1*X1^2+(2.0)*k1*COV11_LNA*X1*Omega-COV22_LNA*X1*k1m*Omega-COV11_LNA*k1m*Omega*X2-(4.0)*k1*X1*COV21_LNA*Omega+X1*k1m*X2-k3*COV21_LNA*Omega-X1*k1m*COV21_LNA*Omega-COV21_LNA*Omega*k2-k1m*COV21_LNA*Omega*X2)*Omega^(-1);
xdot(6)=(k1*X1^2-(2.0)*COV22_LNA*X1*k1m*Omega+(4.0)*k1*X1*COV21_LNA*Omega+k3*X2+X1*k1m*X2-(2.0)*COV22_LNA*k3*Omega-(2.0)*k1m*COV21_LNA*Omega*X2)*Omega^(-1);
xdot(7)=(-COV31_LNA*k4*Omega-COV31_LNA*k1m*Omega*X2-X1*k1m*COV32_LNA*Omega+COV11_LNA*k1m*Omega*X2-X1*k1m*X2+X1*k1m*COV21_LNA*Omega-COV31_LNA*Omega*k2-(4.0)*k1*COV31_LNA*X1*Omega)*Omega^(-1);
xdot(8)=(-k3*COV32_LNA*Omega+COV22_LNA*X1*k1m*Omega-COV31_LNA*k1m*Omega*X2-X1*k1m*COV32_LNA*Omega-X1*k1m*X2-k4*COV32_LNA*Omega+k1m*COV21_LNA*Omega*X2+(2.0)*k1*COV31_LNA*X1*Omega)*Omega^(-1);
xdot(9)=(-(2.0)*COV33_LNA*k4*Omega+2*COV31_LNA*k1m*Omega*X2+X3*k4+2*X1*k1m*COV32_LNA*Omega+X1*k1m*X2)*Omega^(-1);

%% INITIAL CONDITIONS

x0 = sym(zeros(9,1));

%% OBSERVABLES

y = sym(zeros(6,1));

y(1) = X1;
y(2) = X2;
y(3) = X3;
y(4) = COV11_LNA;
y(5) = COV22_LNA;
y(6) = COV33_LNA;

%% SYSTEM STRUCT

model.sym.x = x;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end