function [model] = model_trimerization_IOS_syms()

%% CVODES OPTIONS

% absolute tolerance
model.atol = 1e-8;
% relative tolerance
model.rtol = 1e-8;
% maximal number of steps
model.maxsteps = 1e4;

%% STATES

syms X1 X2 X3

x = [X1,X2,X3];

%% PARAMETERS

syms k0 k1 k1m k2 k3 k4 Omega

p = [k0,k1,k1m,k2,k3,k4,Omega];

%% SYSTEM EQUATIONS

xdot = sym(zeros(size(x)));

% RRE-MEAN
xdot(1)=-X1*k2+(30.0)*k0-(2.0)*k1*X1^2-X1*k1m*X2;
xdot(2)=k1*X1^2-k3*X2-X1*k1m*X2;
xdot(3)=-X3*k4+X1*k1m*X2;

%% INITIAL CONDITIONS

x0 = sym(zeros(3,1));

%% OBSERVABLES

y = sym(zeros(3,1));

y(1) = X1;
y(2) = X2;
y(3) = X3;

%% SYSTEM STRUCT

model.sym.x = x;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end