function optimize_JakStat(model)

rng(0);

DATA = xlsread('pnas_data_original.xls');

% ind_d2d = [4,5,6,7,1,13,14,15,16,17,3,2,9,8,11,12,10];

D.t = DATA(:,1);
D.my(:,1) = DATA(:,2);
D.my(:,2) = DATA(:,4);
D.my(:,3) = DATA(:,6);

options_MS.n_starts = 1000;
options_MS.mode = 'visual';

parameters.min   = -5*ones(17,1);
parameters.max   =  3*ones(17,1);
parameters.max(5) = 6;
parameters.max(2) = 6;
parameters.min(5) = -3;
parameters.min(2) = -3;


parameters.name = {'log_{10}(p1)','log_{10}(p2)','log_{10}(p3)','log_{10}(p4)','log_{10}(init_STAT)',...
    'log_{10}(sp1)','log_{10}(sp2)','log_{10}(sp3)','log_{10}(sp4)','log_{10}(sp5)',...
    'log_{10}(offset_{tSTAT})','log_{10}(offstet_{pSTAT})','log_{10}(scale_{tSTAT})','log_{10}(scale_{pSTAT})',...
    'log_{10}(\sigma_{pSTAT})','log_{10}(\sigma_{tSTAT})','log_{10}(\sigma_{pEpoR})'};
parameters.number = length(parameters.min);

kappa(1) = 1.4;% Omega_cyt
kappa(2) = 0.45;% Omega_nuc

options_MS.fmincon = optimset('algorithm','trust-region-reflective',...%'interior-point',...
    'display','iter',...
    'GradObj','on',...
    'Hessian','user-supplied',...
    'MaxIter',5000,...
    'TolCon',0,...
    'TolFun',1e-6,...
    'TolX',1e-10,...
    'MaxPCGIter',100,...
    'TolPCG',0.0001,...
    'MaxFunEvals',1000*parameters.number);

options_MS.nsimu_run = 1e5;
options_MS.trace = true;

% [g,g_fd_f,g_fd_b,g_fd_c] = testGradient(parameters_RRE.MS.par(:,1),@(theta) logLikelihoodJakStat(theta,kappa,D,'RRE'),1e-4,1,2)
% [g,g_fd_f,g_fd_b,g_fd_c] = testGradient(parameters_RRE.MS.par(:,1),@(theta) logLikelihoodJakStat(theta,kappa,D,'RRE'),1e-4,2,3)

switch model
    case 'RRE'
        parameters_RRE = getMultiStarts(parameters,@(xi) logLikelihoodJakStat(xi,kappa,D,'RRE'),options_MS);
        save(['./project/results/JakSTAT/results_RRE_jakstat.mat'])
    case 'EMRE'
        parameters_EMRE  = getMultiStarts(parameters,@(xi) logLikelihoodJakStat(xi,kappa,D,'EMRE'),options_MS);
        save(['./project/results/JakSTAT/results_EMRE_jakstat.mat'])
    case 'MA2'
        parameters_2MA  = getMultiStarts(parameters,@(xi) logLikelihoodJakStat(xi,kappa,D,'2MA'),options_MS);
        save(['./project/results/JakSTAT/results_MA2_jakstat.mat'])
end

