function optimize_volume(model,r,nvol,nsample)
    
    warning off
    
    r = str2double(r);
    
    rng(r);
    
    MM = round(10.^linspace(2,5,nsample));
    switch(model)
        case 'model_1'
            MM = MM(1:nsample);
        case 'model_trimerization'
            MM = MM(1:nsample);
    end
    
    date_now = 'paper';
    
    for M = MM
        
        switch(model)
            case 'model_1'
                options_MS.logPost_options.model = model;
            case 'model_trimerization'
                options_MS.logPost_options.model = model;
        end
        
        
        % eval(['cd ' strrep(mfilename('fullpath'),mfilename('full'),'')])
        
        IOS_flag = 1;
        EMRE_flag = 1;
        LNA_flag = 1;
        RRE_flag = 1;
        MA2_flag = 1;
        MA3_flag = 1;
        
        switch model
            case 'model_1'
                % Name of measurands
                output_name = {'mRNA','protein','enzyme'};
                
                options_MS.logPost_options.y_ind = [1,2,3];
                
                % True parameter
                theta_true = [1;...     % k2
                    2.25;...  % k0
                    10;...    % kdm
                    4;...     % ks
                    100;...   % k1
                    1;...     % km2
                    1;...     % cE0
                    NaN];     % Omega (-> Omega not fixed)
                
                % Range of system volumes
                Omega = 10.^linspace(0,4,nvol);
                
                % Number of measured cells per conditions
                % M = 1000;
                filename = ['SSADATA_logt_M_' num2str(M) ];
                
                
                % Simulation time vector for visualization
                t_sim = linspace(0,30,200);
                
                % Parameter struct
                parameters.min   = -4*ones(8,1);
                parameters.max   =  4*ones(8,1);
                parameters.max(3) = 5;
                parameters.max(5) = 6;
                parameters.max(8) = 5;
                parameters.min(3) = -3;
                parameters.min(5) = -2;
                parameters.min(8) = -1;
                
                parameters.name = {'log_{10}(k_2)','log_{10}(k_0)',...
                    'log_{10}(k_{dm})','log_{10}(k_s)',...
                    'log_{10}(k_1)','log_{10}(k_{m2})',...
                    'log_{10}(cE0)','log_{10}(\Omega)'};
                parameters.number = length(parameters.min);
                
            case 'model_trimerization'
                % Name of measurands
                output_name = {'X1','X2','X3'};
                
                options_MS.logPost_options.y_ind = [1,2,3];
                
                % True parameter
                theta_true = [0.333333;...     % k0
                    0.5;...  % k1
                    1;...    % k1m
                    1;...     % k2
                    1;...   % k3
                    1;...     % k4
                    NaN];     % Omega (-> Omega not fixed)
                
                % Range of system volumes
                Omega = 10.^linspace(0,4,nvol);
                
                % Number of measured cells per conditions
                filename = ['SSADATA_logt_M_' num2str(M) ];
                
                
                % Simulation time vector for visualization
                t_sim = linspace(0,30,200);
                
                % Parameter struct
                parameters.min   = -2*ones(7,1);
                parameters.max   =  4*ones(7,1);
                
                parameters.name = {'log_{10}(k_0)','log_{10}(k_1)',...
                    'log_{10}(k_{1m})','log_{10}(k_2)',...
                    'log_{10}(k_3)','log_{10}(k_{4})',...
                    'log_{10}(\Omega)'};
                parameters.number = length(parameters.min);
                
                
        end
        
        
        % Optimization setting
        options_MS.fmincon = optimset('algorithm','trust-region-reflective',...%'interior-point',...
            'display','off',...
            'GradObj','on',...
            'Hessian','user-supplied',...
            'MaxIter',200,...
            'TolCon',0,...
            'TolFun',1e-6,...
            'TolX',1e-6,...
            'MaxPCGIter',100,...
            'TolPCG',0.001,...
            'MaxFunEvals',1000*parameters.number);
        
        options_MS.n_starts = 50;
        options_MS.comp_type = 'sequential';
        options_MS.mode = 'visual';
        options_MS.plot = 'false';
        
        
        IOS_flag = 1;
        EMRE_flag = 1;
        LNA_flag = 1;
        RRE_flag = 1;
        MA2_flag = 1;
        MA3_flag = 1;
        
        if(~exist(['./project/results/' options_MS.logPost_options.model '/' filename '/' date_now],'dir'))
            mkdir(['./project/results/' options_MS.logPost_options.model '/' filename '/' date_now '/MS'])
            mkdir(['./project/results/' options_MS.logPost_options.model '/' filename '/' date_now '/PL'])
            mkdir(['./project/results/' options_MS.logPost_options.model '/' filename '/' date_now '/FIT'])
        end
        
        for o = 1:length(Omega)
                        D = [];
                        disp([ num2str(clock) ' starting volume' num2str(o) ' replicate ' num2str(r) ' samplesize ' num2str(M) ])
            
                        DATA = load(['./data/' options_MS.logPost_options.model '/Data_' num2str(Omega(o),'%d') '_logt.mat']);
            
                        D.m = zeros(size(DATA.X,1),size(DATA.X,2));
                        D.sigma_m = zeros(size(DATA.X,1),size(DATA.X,2));
                        D.C = zeros(size(DATA.X,1),size(DATA.X,2));
                        D.sigma_C = zeros(size(DATA.X,1),size(DATA.X,2));
                        D.t = DATA.t;
                        Y = zeros(length(D.t),size(DATA.X,2),M);
                        % Subsampling of data points M>size(DATA.X,3)!!!
                        for k=1:length(D.t)
                            ind_data = randi(size(DATA.X,3),M,1);
                            Y(k,:,:) = DATA.X(k,:,ind_data)/Omega(o);
                        end
            
                        % Loop: Time points
                        for k = 1:length(DATA.t)
                            % Measurement
                            D.my(k,:) = mean(Y(k,:,:),3);
                            D.Cy(k,:) = var(Y(k,:,:),1,3);
                            % Measurement uncertainty
                            D.sigma_my(k,:) = sqrt(D.Cy(k,:)/M);
                            D.sigma_Cy(k,:) = sqrt(mean(bsxfun(@minus,Y(k,:,:),D.my(k,:)).^4,3)...
                                -(M-3)/(M-1)*D.Cy(k,:).^2)/sqrt(M);
                        end
            
                        % Reduction of time points
                        switch model
                            case 'model_1'
                                ind = 1:10:length(DATA.t);
                            case 'model_trimerization'
                                ind = 1:10:length(DATA.t);
                            case 'model_1_noMRNA'
                                ind = 1:10:length(DATA.t);
                            case 'model_1_noProtein'
                                ind = 1:10:length(DATA.t);
                            case 'model_1_noComplex'
                                ind = 1:10:length(DATA.t);
                        end
                        D.t = D.t(ind);
                        D.my = D.my(ind,:);
                        D.Cy = D.Cy(ind,:);
                        D.sigma_my = D.sigma_my(ind,:);
                        D.sigma_Cy = D.sigma_Cy(ind,:);
            
            % Optimization - RRE
            if(RRE_flag)
                disp([ num2str(clock) ' estimating RRE volume' num2str(o) ' replicate ' num2str(r)])
                parameters_RRE = parameters;
                parameters_RRE.min(end) = [];
                parameters_RRE.max(end) = [];
                parameters_RRE.name(end) = [];
                parameters_RRE.number = parameters_RRE.number - 1;
                options_MS_RRE = options_MS;
                options_MS_RRE.logPost_options.grad_ind = 1:parameters_RRE.number;
                parameters_RRE  = getMultiStarts(parameters_RRE,@(xi) logLikelihoodSSE([xi;Omega(o)],D,'RRE' ,options_MS_RRE.logPost_options),options_MS_RRE);
                parameters_volume_RRE(o) = parameters_RRE;
                if(any([strcmp(model,'model_1_noMRNA'),strcmp(model,'model_1_noProtein'),strcmp(model,'model_1_noComplex')]))
                    options_MS_RRE.calc_profile = 'true';
                    options_MS_RRE.parameter_index = 1:parameters.number-1;
                    parameters_volume_RRE_PL(o) = getProfiles(parameters_RRE,@(xi) logLikelihoodSSE([xi;Omega(o)],D,'RRE' ,options_MS_RRE.logPost_options),options_MS_RRE);
                end
            end
            
            % Optimization - LNA
            if(LNA_flag)
                disp([ num2str(clock) ' estimating LNA volume' num2str(o) ' replicate ' num2str(r)])
                parameters_LNA  = getMultiStarts(parameters,@(xi) logLikelihoodSSE(xi,D,'LNA' ,options_MS.logPost_options),options_MS);
                parameters_volume_LNA(o) = parameters_LNA;
                if(any([strcmp(model,'model_1_noMRNA'),strcmp(model,'model_1_noProtein'),strcmp(model,'model_1_noComplex')]))
                    options_MS.calc_profile = 'true';
                    options_MS.parameter_index = 1:parameters.number;
                    parameters_volume_LNA_PL(o) = getProfiles(parameters_LNA,@(xi) logLikelihoodSSE(xi,D,'LNA' ,options_MS.logPost_options),options_MS);
                end
            end
            
            % Optimization - IOS
            if(IOS_flag)
                disp([ num2str(clock) ' estimating IOS volume' num2str(o) ' replicate ' num2str(r)])
                parameters_IOS  = getMultiStarts(parameters,@(xi) logLikelihoodSSE(xi,D,'IOS' ,options_MS.logPost_options),options_MS);
                parameters_volume_IOS(o) = parameters_IOS;
                if(any([strcmp(model,'model_1_noMRNA'),strcmp(model,'model_1_noProtein'),strcmp(model,'model_1_noComplex')]))
                    options_MS.calc_profile = 'true';
                    options_MS.parameter_index = 1:parameters.number;
                    parameters_volume_IOS_PL(o) = getProfiles(parameters_IOS,@(xi) logLikelihoodSSE(xi,D,'IOS' ,options_MS.logPost_options),options_MS);
                end
            end
            
            % Optimization - EMRE
            if(EMRE_flag)
                disp([ num2str(clock) ' estimating EMRE volume' num2str(o) ' replicate ' num2str(r)])
                parameters_EMRE = getMultiStarts(parameters,@(xi) logLikelihoodSSE(xi,D,'EMRE',options_MS.logPost_options),options_MS);
                parameters_volume_EMRE(o) = parameters_EMRE;
                if(any([strcmp(model,'model_1_noMRNA'),strcmp(model,'model_1_noProtein'),strcmp(model,'model_1_noComplex')]))
                    options_MS.calc_profile = 'true';
                    options_MS.parameter_index = 1:parameters.number;
                    parameters_volume_EMRE_PL(o) = getProfiles(parameters_EMRE,@(xi) logLikelihoodSSE(xi,D,'EMRE' ,options_MS.logPost_options),options_MS);
                end
            end
            
            % Optimization - MA2
            if(MA2_flag)
                disp([ num2str(clock) ' estimating 2MA volume' num2str(o) ' replicate ' num2str(r)])
                parameters_2MA = getMultiStarts(parameters,@(xi) logLikelihoodSSE(xi,D,'2MA',options_MS.logPost_options),options_MS);
                parameters_volume_MA2(o) = parameters_2MA;
                if(any([strcmp(model,'model_1_noMRNA'),strcmp(model,'model_1_noProtein'),strcmp(model,'model_1_noComplex')]))
                    options_MS.calc_profile = 'true';
                    options_MS.parameter_index = 1:parameters.number;
                    parameters_volume_MA2_PL(o) = getProfiles(parameters_2MA,@(xi) logLikelihoodSSE(xi,D,'2MA' ,options_MS.logPost_options),options_MS);
                end
            end
            
            % Optimization - MA3
            if(MA3_flag)
                disp([ num2str(clock) ' estimating 3MA volume' num2str(o) ' replicate ' num2str(r)])
                parameters_3MA = getMultiStarts(parameters,@(xi) logLikelihoodSSE(xi,D,'3MA',options_MS.logPost_options),options_MS);
                parameters_volume_MA3(o) = parameters_3MA;
                if(any([strcmp(model,'model_1_noMRNA'),strcmp(model,'model_1_noProtein'),strcmp(model,'model_1_noComplex')]))
                    options_MS.calc_profile = 'true';
                    options_MS.parameter_index = 1:parameters.number;
                    parameters_volume_MA3_PL(o) = getProfiles(parameters_3MA,@(xi) logLikelihoodSSE(xi,D,'3MA' ,options_MS.logPost_options),options_MS);
                end
            end
            close all
            D_volume(o) = D;
            
        end
        % Save Results
        
        disp([ num2str(clock) ' done volume' num2str(o) ' replicate ' num2str(r)])
        save(['./project/results/' options_MS.logPost_options.model '/' filename '/' date_now '/results_r=' num2str(r) ],...
            'parameters_volume_RRE',...
            'parameters_volume_EMRE',...
            'parameters_volume_LNA',...
            'parameters_volume_IOS',...
            'parameters_volume_MA2',...
            'parameters_volume_MA3',...
            'D_volume','M',...
            'theta_true','Omega',...
            'options_MS','parameters','filename');
        
    end
end