clear
close all
clc

%% model_1

Omega = [10.^linspace(0,4,33)]; % Volume range
Omega = Omega(1:33);

N = 1000;

mex('./data/model_1/SSA_gene_enzyme.cpp')

t = logspace(log10(1e-4),log10(30),301); % time points

t_SSA_enzyme = NaN(size(Omega));

for i=1:length(Omega)
    tic
    [~,X,m,C] = runSSA_gene_enzyme(Omega(i),t,N);
    t_SSA_enzyme(i) = toc;
end

k2    = 1;
k0    = 2.25;
kdm   = 10;
ks    = 4;
k1    = 100;
km2   = 1;
cE0   = 1;


% cvodewrap('model_1_RRE','model_1_RRE_syms')
% cvodewrap('model_1_LNA','model_1_LNA_syms')
% cvodewrap('model_1_EMRE','model_1_EMRE_syms')
cvodewrap('model_1_IOS','model_1_IOS_syms')
% cvodewrap('model_1_2MA','MEC_2_LD_2_enzyme_syms')
cvodewrap('model_1_3MA','MEC_3_LD_3_enzyme_syms')

t_RRE_enzyme = NaN(N,length(Omega));
t_LNA_enzyme = NaN(N,length(Omega));
t_EMRE_enzyme = NaN(N,length(Omega));
t_IOS_enzyme = NaN(N,length(Omega));
t_2MA_enzyme = NaN(N,length(Omega));
t_3MA_enzyme = NaN(N,length(Omega));

for i = 1:length(Omega)
    for n = 1:N;
        p = [k2,k0,kdm,ks,k1,km2,cE0,Omega(i)];
        tic;
%         options.sensi = 0;
%         sol = simulate_model_1_RRE(t,p,[],options);
%         t_RRE_enzyme(n,i) = toc;
%         options.sensi = 0;
%         sol = simulate_model_1_LNA(t,p,[],options);
%         t_LNA_enzyme(n,i) = toc;
%         options.sensi = 0;
%         sol = simulate_model_1_EMRE(t,p,[],options);
%         t_EMRE_enzyme(n,i) = toc;
        options.sensi = 0;
        sol = simulate_model_1_IOS(t,p,[],options);
        t_IOS_enzyme(n,i) = toc;
%         options.sensi = 0;
%         sol = simulate_model_1_2MA(t,p,[],options);
%         t_2MA_enzyme(n,i) = toc;
        options.sensi = 0;
        sol = simulate_model_1_3MA(t,p,[],options);
        t_3MA_enzyme(n,i) = toc;
    end
end



%% trimerization

Omega = [10.^linspace(0,4,33)]; % Volume range
Omega = Omega(1:33);

N = 1000;

mex('./data/model_trimerization/SSA_trimerization.cpp')

t = logspace(log10(1e-2),log10(5),301);

t_SSA_trimerization = NaN(size(Omega));

for i=1:length(Omega)
    tic
    [~,X,m,C] = runSSA_trimerization(Omega(i),t,N);
    t_SSA_trimerization(i) = toc;
end

k0    = 0.333333;
k1    = 0.5;
k1m   = 1;
k2    = 1;
k3    = 1;
k4    = 1;

% cvodewrap('model_trimerization_RRE','model_trimerization_RRE_syms')
% cvodewrap('model_trimerization_LNA','model_trimerization_LNA_syms')
% cvodewrap('model_trimerization_EMRE','model_trimerization_EMRE_syms')
cvodewrap('model_trimerization_IOS','model_trimerization_IOS_syms')
% cvodewrap('model_trimerization_2MA','MEC_2_LD_2_trimerization_syms')
cvodewrap('model_trimerization_3MA','MEC_3_LD_3_trimerization_syms')

% t_RRE_trimerization = NaN(N,length(Omega));
% t_LNA_trimerization = NaN(N,length(Omega));
% t_EMRE_trimerization = NaN(N,length(Omega));
t_IOS_trimerization = NaN(N,length(Omega));
% t_2MA_trimerization = NaN(N,length(Omega));
t_3MA_trimerization = NaN(N,length(Omega));

for i = 1:length(Omega)
    for n = 1:N;
        p = [k0,k1,k1m,k2,k3,k4,Omega(i)];
        tic;
%         options.sensi = 0;
%         sol = simulate_model_trimerization_RRE(t,p,[],options);
%         t_RRE_trimerization(n,i) = toc;
%         options.sensi = 0;
%         sol = simulate_model_trimerization_LNA(t,p,[],options);
%         t_LNA_trimerization(n,i) = toc;
%         options.sensi = 0;
%         sol = simulate_model_trimerization_EMRE(t,p,[],options);
%         t_EMRE_trimerization(n,i) = toc;
        options.sensi = 0;
        sol = simulate_model_trimerization_IOS(t,p,[],options);
        t_IOS_trimerization(n,i) = toc;
%         options.sensi = 0;
%         sol = simulate_model_trimerization_2MA(t,p,[],options);
%         t_2MA_trimerization(n,i) = toc;
        options.sensi = 0;
        sol = simulate_model_trimerization_3MA(t,p,[],options);
        t_3MA_trimerization(n,i) = toc;
    end
end

%% plot

cIOS = [134/255,153/255,101/255];
c3MA = [153/255,89/255,118/255];

figure
subplot(1,2,1)
plot(Omega,t_SSA_trimerization/100,'Color',[0.6,0.6,0.6],'LineWidth',1.5)
hold on
plot(Omega,t_SSA_trimerization/10,'Color',[0.3,0.3,0.3],'LineWidth',1.5)
plot(Omega,t_SSA_trimerization/1,'Color',[0,0,0],'LineWidth',1.5)
plot(Omega,mean(t_IOS_trimerization,1),'Color',cIOS,'LineWidth',1.5)
plot(Omega,mean(t_3MA_trimerization,1),'Color',c3MA,'LineWidth',1.5)
set(gca,'XScale','log')
set(gca,'YScale','log')
set(gca,'LineWidth',1.5)
set(gca,'FontSize',15)
box on

xlabel('volume \Omega')
ylabel('computation time')
legend('10x SSA','100x SSA','1000x SSA','IOS','3MA')
legend BOXOFF

subplot(1,2,2)
plot(Omega,t_SSA_enzyme/100,'Color',[0.6,0.6,0.6],'LineWidth',1.5)
hold on
plot(Omega,t_SSA_enzyme/10,'Color',[0.3,0.3,0.3],'LineWidth',1.5)
plot(Omega,t_SSA_enzyme/1,'Color',[0,0,0],'LineWidth',1.5)
plot(Omega,mean(t_IOS_enzyme,1),'Color',cIOS,'LineWidth',1.5)
plot(Omega,mean(t_3MA_enzyme,1),'Color',c3MA,'LineWidth',1.5)
set(gca,'XScale','log')
set(gca,'YScale','log')
set(gca,'LineWidth',1.5)
set(gca,'FontSize',15)
box on
xlabel('volume \Omega')
ylabel('computation time')

set(gcf, 'PaperUnits','centimeters','PaperSize',[56 39],'PaperPositionMode','auto','Position',[0 0 1000 640])









